/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL41;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBGetProgramBinary {
    public static final int GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 33367;
    public static final int GL_PROGRAM_BINARY_LENGTH = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS = 34815;
    public final long GetProgramBinary;
    public final long ProgramBinary;
    public final long ProgramParameteri;

    public ARBGetProgramBinary(FunctionProvider provider) {
        this.GetProgramBinary = provider.getFunctionAddress("glGetProgramBinary");
        this.ProgramBinary = provider.getFunctionAddress("glProgramBinary");
        this.ProgramParameteri = provider.getFunctionAddress("glProgramParameteri");
    }

    public static ARBGetProgramBinary getInstance() {
        return GL.getCapabilities().__ARBGetProgramBinary;
    }

    static ARBGetProgramBinary create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_get_program_binary")) {
            return null;
        }
        ARBGetProgramBinary funcs = new ARBGetProgramBinary(provider);
        boolean supported = Checks.checkFunctions(funcs.GetProgramBinary, funcs.ProgramBinary, funcs.ProgramParameteri);
        return GL.checkExtension("GL_ARB_get_program_binary", funcs, supported);
    }

    public static void nglGetProgramBinary(int program, int bufSize, long length, long binaryFormat, long binary) {
        long __functionAddress = ARBGetProgramBinary.getInstance().GetProgramBinary;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGetProgramBinary(program, bufSize, length, binaryFormat, binary, __functionAddress);
    }

    public static void glGetProgramBinary(int program, int bufSize, ByteBuffer length, ByteBuffer binaryFormat, ByteBuffer binary) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)binary, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)binaryFormat, 4);
        }
        ARBGetProgramBinary.nglGetProgramBinary(program, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static void glGetProgramBinary(int program, IntBuffer length, IntBuffer binaryFormat, ByteBuffer binary) {
        if (LWJGLUtil.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        ARBGetProgramBinary.nglGetProgramBinary(program, binary.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static ByteBuffer glGetProgramBinary(int program, int bufSize, IntBuffer binaryFormat) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int binary = __buffer.bufferParam(bufSize);
        ARBGetProgramBinary.nglGetProgramBinary(program, bufSize, __buffer.address(length), MemoryUtil.memAddress(binaryFormat), __buffer.address(binary));
        return MemoryUtil.memByteBuffer(__buffer.address(binary), __buffer.intValue(length));
    }

    public static ByteBuffer glGetProgramBinary(int program, IntBuffer binaryFormat) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        int bufSize = GL20.glGetProgrami(program, 34625);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int binary = __buffer.bufferParam(bufSize);
        ARBGetProgramBinary.nglGetProgramBinary(program, bufSize, __buffer.address(length), MemoryUtil.memAddress(binaryFormat), __buffer.address(binary));
        return MemoryUtil.memByteBuffer(__buffer.address(binary), __buffer.intValue(length));
    }

    public static void nglProgramBinary(int program, int binaryFormat, long binary, int length) {
        long __functionAddress = ARBGetProgramBinary.getInstance().ProgramBinary;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramBinary(program, binaryFormat, binary, length, __functionAddress);
    }

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary, int length) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)binary, length);
        }
        ARBGetProgramBinary.nglProgramBinary(program, binaryFormat, MemoryUtil.memAddress(binary), length);
    }

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary) {
        ARBGetProgramBinary.nglProgramBinary(program, binaryFormat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void glProgramParameteri(int program, int pname, int value) {
        long __functionAddress = ARBGetProgramBinary.getInstance().ProgramParameteri;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramParameteri(program, pname, value, __functionAddress);
    }
}

