/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL11;
import org.lwjgl.opencl.CL12;
import org.lwjgl.opencl.KHRICD;
import org.lwjgl.opencl.OpenCLException;

public final class CLUtil {
    private static final Map<Integer, String> CL_ERROR_TOKENS = LWJGLUtil.getClassTokens(new LWJGLUtil.TokenFilter(){

        @Override
        public boolean accept(Field field, int value) {
            return value < 0;
        }
    }, null, CL10.class, CL11.class, CL12.class, LWJGLUtil.getOptionalClass("org.lwjgl.opencl.KHRGLSharing"), KHRICD.class, LWJGLUtil.getOptionalClass("org.lwjgl.opencl.APPLEGLSharing"));

    private CLUtil() {
    }

    public static void checkCLError(ByteBuffer errcode_ret) {
        CLUtil.checkCLError(errcode_ret.getInt(errcode_ret.position()));
    }

    public static void checkCLError(IntBuffer errcode_ret) {
        CLUtil.checkCLError(errcode_ret.get(errcode_ret.position()));
    }

    public static void checkCLError(int errcode) {
        if (errcode != 0) {
            throw new OpenCLException("Error Code: " + CLUtil.getErrcodeName(errcode));
        }
    }

    public static String getErrcodeName(int errcode) {
        String errname = CL_ERROR_TOKENS.get(errcode);
        if (errname == null) {
            errname = String.format("UNKNOWN [0x%X]", errcode);
        }
        return errname;
    }
}

