/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLUtil;
import org.lwjgl.opencl.Info;
import org.lwjgl.opencl.OpenCLException;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.PointerWrapper;

public class CLPlatform
extends PointerWrapper {
    private final CLCapabilities capabilities;

    public CLPlatform(long cl_platform_id) {
        super(cl_platform_id);
        this.capabilities = CLPlatform.createCapabilities(cl_platform_id);
    }

    public CLCapabilities getCapabilities() {
        return this.capabilities;
    }

    public static CLCapabilities createCapabilities(long cl_platform_id) {
        int i;
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        String extensionsString = Info.clGetPlatformInfoStringASCII(cl_platform_id, 2308);
        CL.addExtensions(extensionsString, supportedExtensions);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int errcode = CL10.nclGetDeviceIDs(cl_platform_id, -1L, 0, 0L, __buffer.address());
        if (LWJGLUtil.DEBUG && errcode != 0) {
            throw new OpenCLException("Failed to query number of OpenCL platform devices.");
        }
        int num_devices = __buffer.intValue(0);
        if (num_devices == 0) {
            return null;
        }
        __buffer.bufferParam(num_devices << POINTER_SHIFT);
        errcode = CL10.nclGetDeviceIDs(cl_platform_id, -1L, num_devices, __buffer.address(), 0L);
        if (LWJGLUtil.DEBUG && errcode != 0) {
            throw new OpenCLException("Failed to query OpenCL platform devices.");
        }
        long[] devices = new long[num_devices];
        for (i = 0; i < num_devices; ++i) {
            devices[i] = __buffer.pointerValue(i << POINTER_SHIFT);
        }
        for (i = 0; i < num_devices; ++i) {
            extensionsString = Info.clGetDeviceInfoStringASCII(devices[i], 4144);
            CL.addExtensions(extensionsString, supportedExtensions);
        }
        APIUtil.APIVersion version = APIUtil.apiParseVersion(Info.clGetPlatformInfoStringASCII(cl_platform_id, 2305), "OpenCL");
        CL.addCLVersions(version.major, version.minor, supportedExtensions);
        return new CLCapabilities(version.major, version.minor, supportedExtensions, CL.getICD());
    }

    public static List<CLPlatform> getPlatforms() {
        return CLPlatform.getPlatforms(null);
    }

    public static List<CLPlatform> getPlatforms(Filter<CLPlatform> filter) {
        long clGetPlatformIDs = CL10.getInstance().GetPlatformIDs;
        APIBuffer __buffer = APIUtil.apiBuffer();
        int errcode = CL10.nclGetPlatformIDs(0, 0L, __buffer.address(), clGetPlatformIDs);
        CLUtil.checkCLError(errcode);
        int num_platforms = __buffer.intValue(0);
        if (num_platforms == 0) {
            return Collections.emptyList();
        }
        __buffer.bufferParam(num_platforms << POINTER_SHIFT);
        errcode = CL10.nclGetPlatformIDs(num_platforms, __buffer.address(), 0L, clGetPlatformIDs);
        CLUtil.checkCLError(errcode);
        long[] platformIDs = new long[num_platforms];
        for (int i = 0; i < num_platforms; ++i) {
            platformIDs[i] = __buffer.pointerValue(i << POINTER_SHIFT);
        }
        return CLPlatform.filterObjects(platformIDs, filter, new Factory<CLPlatform>(){

            @Override
            public CLPlatform create(long object_id) {
                return new CLPlatform(object_id);
            }
        });
    }

    public List<CLDevice> getDevices(int device_type) {
        return this.getDevices(device_type, null);
    }

    public List<CLDevice> getDevices(int device_type, Filter<CLDevice> filter) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int errcode = CL10.clGetDeviceIDs(this.getPointer(), device_type, 0, null, __buffer.buffer());
        CLUtil.checkCLError(errcode);
        int num_devices = __buffer.intValue(0);
        if (num_devices == 0) {
            return Collections.emptyList();
        }
        __buffer.bufferParam(num_devices << POINTER_SHIFT);
        errcode = CL10.clGetDeviceIDs(this.getPointer(), device_type, num_devices, __buffer.buffer(), null);
        CLUtil.checkCLError(errcode);
        long[] deviceIDs = new long[num_devices];
        for (int i = 0; i < num_devices; ++i) {
            deviceIDs[i] = __buffer.pointerValue(i << POINTER_SHIFT);
        }
        return CLPlatform.filterObjects(deviceIDs, filter, new Factory<CLDevice>(){

            @Override
            public CLDevice create(long object_id) {
                return new CLDevice(object_id, CLPlatform.this.getCapabilities());
            }
        });
    }

    private static <T> List<T> filterObjects(long[] objects, Filter<T> filter, Factory<T> factory) {
        ArrayList<T> list = new ArrayList<T>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            T object = factory.create(objects[i]);
            if (filter != null && !filter.accept(object)) continue;
            list.add(object);
        }
        if (list.size() < objects.length) {
            list.trimToSize();
        }
        return list;
    }

    private static interface Factory<T> {
        public T create(long var1);
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }
}

