/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class CLImageFormat
implements Pointer {
    public static final int SIZEOF;
    public static final int IMAGE_CHANNEL_ORDER;
    public static final int IMAGE_CHANNEL_DATA_TYPE;
    private final ByteBuffer struct;

    public CLImageFormat() {
        this(CLImageFormat.malloc());
    }

    public CLImageFormat(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setImageChannelOrder(int image_channel_order) {
        CLImageFormat.image_channel_order(this.struct, image_channel_order);
    }

    public void setImageChannelDataType(int image_channel_data_type) {
        CLImageFormat.image_channel_data_type(this.struct, image_channel_data_type);
    }

    public int getImageChannelOrder() {
        return CLImageFormat.image_channel_order(this.struct);
    }

    public int getImageChannelDataType() {
        return CLImageFormat.image_channel_data_type(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int image_channel_order, int image_channel_data_type) {
        ByteBuffer cl_image_format = CLImageFormat.malloc();
        CLImageFormat.image_channel_order(cl_image_format, image_channel_order);
        CLImageFormat.image_channel_data_type(cl_image_format, image_channel_data_type);
        return cl_image_format;
    }

    public static void image_channel_order(ByteBuffer cl_image_format, int image_channel_order) {
        cl_image_format.putInt(cl_image_format.position() + IMAGE_CHANNEL_ORDER, image_channel_order);
    }

    public static void image_channel_data_type(ByteBuffer cl_image_format, int image_channel_data_type) {
        cl_image_format.putInt(cl_image_format.position() + IMAGE_CHANNEL_DATA_TYPE, image_channel_data_type);
    }

    public static int image_channel_order(ByteBuffer cl_image_format) {
        return cl_image_format.getInt(cl_image_format.position() + IMAGE_CHANNEL_ORDER);
    }

    public static int image_channel_data_type(ByteBuffer cl_image_format) {
        return cl_image_format.getInt(cl_image_format.position() + IMAGE_CHANNEL_DATA_TYPE);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = CLImageFormat.offsets(MemoryUtil.memAddress(offsets));
        IMAGE_CHANNEL_ORDER = offsets.get(0);
        IMAGE_CHANNEL_DATA_TYPE = offsets.get(1);
    }
}

