/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLImageDesc;
import org.lwjgl.opencl.CLImageFormat;
import org.lwjgl.opencl.CLProgramCallback;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class CL12 {
    public static final int CL_COMPILE_PROGRAM_FAILURE = -15;
    public static final int CL_LINKER_NOT_AVAILABLE = -16;
    public static final int CL_LINK_PROGRAM_FAILURE = -17;
    public static final int CL_DEVICE_PARTITION_FAILED = -18;
    public static final int CL_KERNEL_ARG_INFO_NOT_AVAILABLE = -19;
    public static final int CL_INVALID_IMAGE_DESCRIPTOR = -65;
    public static final int CL_INVALID_COMPILER_OPTIONS = -66;
    public static final int CL_INVALID_LINKER_OPTIONS = -67;
    public static final int CL_INVALID_DEVICE_PARTITION_COUNT = -68;
    public static final int CL_VERSION_1_2 = 1;
    public static final int CL_BLOCKING = 1;
    public static final int CL_NON_BLOCKING = 0;
    public static final int CL_DEVICE_TYPE_CUSTOM = 16;
    public static final int CL_DEVICE_DOUBLE_FP_CONFIG = 4146;
    public static final int CL_DEVICE_LINKER_AVAILABLE = 4158;
    public static final int CL_DEVICE_BUILT_IN_KERNELS = 4159;
    public static final int CL_DEVICE_IMAGE_MAX_BUFFER_SIZE = 4160;
    public static final int CL_DEVICE_IMAGE_MAX_ARRAY_SIZE = 4161;
    public static final int CL_DEVICE_PARENT_DEVICE = 4162;
    public static final int CL_DEVICE_PARTITION_MAX_SUB_DEVICES = 4163;
    public static final int CL_DEVICE_PARTITION_PROPERTIES = 4164;
    public static final int CL_DEVICE_PARTITION_AFFINITY_DOMAIN = 4165;
    public static final int CL_DEVICE_PARTITION_TYPE = 4166;
    public static final int CL_DEVICE_REFERENCE_COUNT = 4167;
    public static final int CL_DEVICE_PREFERRED_INTEROP_USER_SYNC = 4168;
    public static final int CL_DEVICE_PRINTF_BUFFER_SIZE = 4169;
    public static final int CL_FP_CORRECTLY_ROUNDED_DIVIDE_SQRT = 128;
    public static final int CL_CONTEXT_INTEROP_USER_SYNC = 4229;
    public static final int CL_DEVICE_PARTITION_BY_COUNTS_LIST_END = 0;
    public static final int CL_DEVICE_PARTITION_EQUALLY = 4230;
    public static final int CL_DEVICE_PARTITION_BY_COUNTS = 4231;
    public static final int CL_DEVICE_PARTITION_BY_AFFINITY_DOMAIN = 4232;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_NUMA = 1;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_L4_CACHE = 2;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_L3_CACHE = 4;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_L2_CACHE = 8;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_L1_CACHE = 16;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_NEXT_PARTITIONABLE = 32;
    public static final int CL_MEM_HOST_WRITE_ONLY = 128;
    public static final int CL_MEM_HOST_READ_ONLY = 256;
    public static final int CL_MEM_HOST_NO_ACCESS = 512;
    public static final int CL_MIGRATE_MEM_OBJECT_HOST = 1;
    public static final int CL_MIGRATE_MEM_OBJECT_CONTENT_UNDEFINED = 2;
    public static final int CL_MEM_OBJECT_IMAGE2D_ARRAY = 4339;
    public static final int CL_MEM_OBJECT_IMAGE1D = 4340;
    public static final int CL_MEM_OBJECT_IMAGE1D_ARRAY = 4341;
    public static final int CL_MEM_OBJECT_IMAGE1D_BUFFER = 4342;
    public static final int CL_IMAGE_ARRAY_SIZE = 4375;
    public static final int CL_IMAGE_BUFFER = 4376;
    public static final int CL_IMAGE_NUM_MIP_LEVELS = 4377;
    public static final int CL_IMAGE_NUM_SAMPLES = 4378;
    public static final int CL_MAP_WRITE_INVALIDATE_REGION = 4;
    public static final int CL_PROGRAM_NUM_KERNELS = 4455;
    public static final int CL_PROGRAM_KERNEL_NAMES = 4456;
    public static final int CL_PROGRAM_BINARY_TYPE = 4484;
    public static final int CL_PROGRAM_BINARY_TYPE_NONE = 0;
    public static final int CL_PROGRAM_BINARY_TYPE_COMPILED_OBJECT = 1;
    public static final int CL_PROGRAM_BINARY_TYPE_LIBRARY = 2;
    public static final int CL_PROGRAM_BINARY_TYPE_EXECUTABLE = 4;
    public static final int CL_KERNEL_ATTRIBUTES = 4501;
    public static final int CL_KERNEL_ARG_ADDRESS_QUALIFIER = 4502;
    public static final int CL_KERNEL_ARG_ACCESS_QUALIFIER = 4503;
    public static final int CL_KERNEL_ARG_TYPE_NAME = 4504;
    public static final int CL_KERNEL_ARG_TYPE_QUALIFIER = 6553;
    public static final int CL_KERNEL_ARG_NAME = 4506;
    public static final int CL_KERNEL_ARG_ADDRESS_GLOBAL = 4506;
    public static final int CL_KERNEL_ARG_ADDRESS_LOCAL = 4507;
    public static final int CL_KERNEL_ARG_ADDRESS_CONSTANT = 4508;
    public static final int CL_KERNEL_ARG_ADDRESS_PRIVATE = 4509;
    public static final int CL_KERNEL_ARG_ACCESS_READ_ONLY = 4512;
    public static final int CL_KERNEL_ARG_ACCESS_WRITE_ONLY = 4513;
    public static final int CL_KERNEL_ARG_ACCESS_READ_WRITE = 4514;
    public static final int CL_KERNEL_ARG_ACCESS_NONE = 4515;
    public static final int CL_CL_KERNEL_ARG_TYPE_NONE = 0;
    public static final int CL_CL_KERNEL_ARG_TYPE_CONST = 1;
    public static final int CL_CL_KERNEL_ARG_TYPE_RESTRICT = 2;
    public static final int CL_CL_KERNEL_ARG_TYPE_VOLATILE = 4;
    public static final int CL_KERNEL_GLOBAL_WORK_SIZE = 4533;
    public static final int CL_COMMAND_BARRIER = 4613;
    public static final int CL_COMMAND_MIGRATE_MEM_OBJECTS = 4614;
    public static final int CL_COMMAND_FILL_BUFFER = 4615;
    public static final int CL_COMMAND_FILL_IMAGE = 4616;
    public final long GetExtensionFunctionAddressForPlatform;
    public final long RetainDevice;
    public final long ReleaseDevice;
    public final long CreateSubDevices;
    public final long CreateImage;
    public final long CreateProgramWithBuiltInKernels;
    public final long CompileProgram;
    public final long LinkProgram;
    public final long UnloadPlatformCompiler;
    public final long GetKernelArgInfo;
    public final long EnqueueFillBuffer;
    public final long EnqueueFillImage;
    public final long EnqueueMigrateMemObjects;
    public final long EnqueueMarkerWithWaitList;
    public final long EnqueueBarrierWithWaitList;

    public CL12(FunctionProvider provider) {
        this.GetExtensionFunctionAddressForPlatform = provider.getFunctionAddress("clGetExtensionFunctionAddressForPlatform");
        this.RetainDevice = provider.getFunctionAddress("clRetainDevice");
        this.ReleaseDevice = provider.getFunctionAddress("clReleaseDevice");
        this.CreateSubDevices = provider.getFunctionAddress("clCreateSubDevices");
        this.CreateImage = provider.getFunctionAddress("clCreateImage");
        this.CreateProgramWithBuiltInKernels = provider.getFunctionAddress("clCreateProgramWithBuiltInKernels");
        this.CompileProgram = provider.getFunctionAddress("clCompileProgram");
        this.LinkProgram = provider.getFunctionAddress("clLinkProgram");
        this.UnloadPlatformCompiler = provider.getFunctionAddress("clUnloadPlatformCompiler");
        this.GetKernelArgInfo = provider.getFunctionAddress("clGetKernelArgInfo");
        this.EnqueueFillBuffer = provider.getFunctionAddress("clEnqueueFillBuffer");
        this.EnqueueFillImage = provider.getFunctionAddress("clEnqueueFillImage");
        this.EnqueueMigrateMemObjects = provider.getFunctionAddress("clEnqueueMigrateMemObjects");
        this.EnqueueMarkerWithWaitList = provider.getFunctionAddress("clEnqueueMarkerWithWaitList");
        this.EnqueueBarrierWithWaitList = provider.getFunctionAddress("clEnqueueBarrierWithWaitList");
    }

    public static CL12 getInstance() {
        return CL.getICD().__CL12;
    }

    static CL12 create(FunctionProvider provider) {
        CL12 funcs = new CL12(provider);
        boolean supported = Checks.checkFunctions(funcs.GetExtensionFunctionAddressForPlatform, funcs.RetainDevice, funcs.ReleaseDevice, funcs.CreateSubDevices, funcs.CreateImage, funcs.CreateProgramWithBuiltInKernels, funcs.CompileProgram, funcs.LinkProgram, funcs.UnloadPlatformCompiler, funcs.GetKernelArgInfo, funcs.EnqueueFillBuffer, funcs.EnqueueFillImage, funcs.EnqueueMigrateMemObjects, funcs.EnqueueMarkerWithWaitList, funcs.EnqueueBarrierWithWaitList);
        return supported ? funcs : null;
    }

    public static native long nclGetExtensionFunctionAddressForPlatform(long var0, long var2, long var4);

    public static long nclGetExtensionFunctionAddressForPlatform(long platform, long func_name) {
        long __functionAddress = CL12.getInstance().GetExtensionFunctionAddressForPlatform;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(platform);
        }
        return CL12.nclGetExtensionFunctionAddressForPlatform(platform, func_name, __functionAddress);
    }

    public static long clGetExtensionFunctionAddressForPlatform(long platform, ByteBuffer func_name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(func_name);
        }
        return CL12.nclGetExtensionFunctionAddressForPlatform(platform, MemoryUtil.memAddress(func_name));
    }

    public static long clGetExtensionFunctionAddressForPlatform(long platform, CharSequence func_name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int func_nameEncoded = __buffer.stringParamASCII(func_name, true);
        return CL12.nclGetExtensionFunctionAddressForPlatform(platform, __buffer.address(func_nameEncoded));
    }

    public static native int nclRetainDevice(long var0, long var2);

    public static int clRetainDevice(long device) {
        long __functionAddress = CL12.getInstance().RetainDevice;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        return CL12.nclRetainDevice(device, __functionAddress);
    }

    public static native int nclReleaseDevice(long var0, long var2);

    public static int clReleaseDevice(long device) {
        long __functionAddress = CL12.getInstance().ReleaseDevice;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        return CL12.nclReleaseDevice(device, __functionAddress);
    }

    public static native int nclCreateSubDevices(long var0, long var2, int var4, long var5, long var7, long var9);

    public static int nclCreateSubDevices(long in_device, long properties, int num_devices, long out_devices, long num_devices_ret) {
        long __functionAddress = CL12.getInstance().CreateSubDevices;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(in_device);
        }
        return CL12.nclCreateSubDevices(in_device, properties, num_devices, out_devices, num_devices_ret, __functionAddress);
    }

    public static int clCreateSubDevices(long in_device, ByteBuffer properties, int num_devices, ByteBuffer out_devices, ByteBuffer num_devices_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(properties);
            if (out_devices != null) {
                Checks.checkBuffer((Buffer)out_devices, num_devices << Pointer.POINTER_SHIFT);
            }
            if (num_devices_ret != null) {
                Checks.checkBuffer((Buffer)num_devices_ret, 4);
            }
        }
        return CL12.nclCreateSubDevices(in_device, MemoryUtil.memAddress(properties), num_devices, MemoryUtil.memAddressSafe(out_devices), MemoryUtil.memAddressSafe(num_devices_ret));
    }

    public static int clCreateSubDevices(long in_device, PointerBuffer properties, PointerBuffer out_devices, IntBuffer num_devices_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT(properties);
            if (num_devices_ret != null) {
                Checks.checkBuffer((Buffer)num_devices_ret, 1);
            }
        }
        return CL12.nclCreateSubDevices(in_device, MemoryUtil.memAddress(properties), out_devices == null ? 0 : out_devices.remaining(), MemoryUtil.memAddressSafe(out_devices), MemoryUtil.memAddressSafe(num_devices_ret));
    }

    public static native long nclCreateImage(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static long nclCreateImage(long context, long flags, long image_format, long image_desc, long host_ptr, long errcode_ret) {
        long __functionAddress = CL12.getInstance().CreateImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL12.nclCreateImage(context, flags, image_format, image_desc, host_ptr, errcode_ret, __functionAddress);
    }

    public static long clCreateImage(long context, long flags, ByteBuffer image_format, ByteBuffer image_desc, ByteBuffer host_ptr, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, CLImageFormat.SIZEOF);
            Checks.checkBuffer((Buffer)image_desc, CLImageDesc.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return CL12.nclCreateImage(context, flags, MemoryUtil.memAddress(image_format), MemoryUtil.memAddress(image_desc), MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateImage(long context, long flags, ByteBuffer image_format, ByteBuffer image_desc, ByteBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, CLImageFormat.SIZEOF);
            Checks.checkBuffer((Buffer)image_desc, CLImageDesc.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL12.nclCreateImage(context, flags, MemoryUtil.memAddress(image_format), MemoryUtil.memAddress(image_desc), MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateImage(long context, long flags, ByteBuffer image_format, ByteBuffer image_desc, ShortBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, CLImageFormat.SIZEOF);
            Checks.checkBuffer((Buffer)image_desc, CLImageDesc.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL12.nclCreateImage(context, flags, MemoryUtil.memAddress(image_format), MemoryUtil.memAddress(image_desc), MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateImage(long context, long flags, ByteBuffer image_format, ByteBuffer image_desc, IntBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, CLImageFormat.SIZEOF);
            Checks.checkBuffer((Buffer)image_desc, CLImageDesc.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL12.nclCreateImage(context, flags, MemoryUtil.memAddress(image_format), MemoryUtil.memAddress(image_desc), MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateImage(long context, long flags, ByteBuffer image_format, ByteBuffer image_desc, FloatBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, CLImageFormat.SIZEOF);
            Checks.checkBuffer((Buffer)image_desc, CLImageDesc.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL12.nclCreateImage(context, flags, MemoryUtil.memAddress(image_format), MemoryUtil.memAddress(image_desc), MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native long nclCreateProgramWithBuiltInKernels(long var0, int var2, long var3, long var5, long var7, long var9);

    public static long nclCreateProgramWithBuiltInKernels(long context, int num_devices, long device_list, long kernel_names, long errcode_ret) {
        long __functionAddress = CL12.getInstance().CreateProgramWithBuiltInKernels;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL12.nclCreateProgramWithBuiltInKernels(context, num_devices, device_list, kernel_names, errcode_ret, __functionAddress);
    }

    public static long clCreateProgramWithBuiltInKernels(long context, int num_devices, ByteBuffer device_list, ByteBuffer kernel_names, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(kernel_names);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return CL12.nclCreateProgramWithBuiltInKernels(context, num_devices, MemoryUtil.memAddress(device_list), MemoryUtil.memAddress(kernel_names), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateProgramWithBuiltInKernels(long context, int num_devices, PointerBuffer device_list, ByteBuffer kernel_names, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL12.nclCreateProgramWithBuiltInKernels(context, num_devices, MemoryUtil.memAddress(device_list), MemoryUtil.memAddress(kernel_names), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateProgramWithBuiltInKernels(long context, int num_devices, PointerBuffer device_list, CharSequence kernel_names, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int kernel_namesEncoded = __buffer.stringParamASCII(kernel_names, true);
        return CL12.nclCreateProgramWithBuiltInKernels(context, num_devices, MemoryUtil.memAddress(device_list), __buffer.address(kernel_namesEncoded), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateProgramWithBuiltInKernels(long context, int num_devices, long device, CharSequence kernel_names, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int kernel_namesEncoded = __buffer.stringParamASCII(kernel_names, true);
        int device_list = __buffer.pointerParam(device);
        return CL12.nclCreateProgramWithBuiltInKernels(context, num_devices, __buffer.address(device_list), __buffer.address(kernel_namesEncoded), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native int nclCompileProgram(long var0, int var2, long var3, long var5, int var7, long var8, long var10, long var12, long var14, long var16);

    public static int nclCompileProgram(long program, int num_devices, long device_list, long options, int num_input_headers, long input_headers, long header_include_names, long pfn_notify, long user_data) {
        long __functionAddress = CL12.getInstance().CompileProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(program);
        }
        return CL12.nclCompileProgram(program, num_devices, device_list, options, num_input_headers, input_headers, header_include_names, pfn_notify, user_data, __functionAddress);
    }

    public static int clCompileProgram(long program, int num_devices, ByteBuffer device_list, ByteBuffer options, int num_input_headers, ByteBuffer input_headers, ByteBuffer header_include_names, CLProgramCallback pfn_notify, long user_data) {
        if (LWJGLUtil.CHECKS) {
            if (device_list != null) {
                Checks.checkBuffer((Buffer)device_list, num_devices << Pointer.POINTER_SHIFT);
            }
            Checks.checkNT1(options);
            if (input_headers != null) {
                Checks.checkBuffer((Buffer)input_headers, num_input_headers << Pointer.POINTER_SHIFT);
            }
            if (header_include_names != null) {
                Checks.checkBuffer((Buffer)header_include_names, num_input_headers << Pointer.POINTER_SHIFT);
            }
        }
        return CL12.nclCompileProgram(program, num_devices, MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(options), num_input_headers, MemoryUtil.memAddressSafe(input_headers), MemoryUtil.memAddressSafe(header_include_names), pfn_notify == null ? 0L : pfn_notify.getPointer(), user_data);
    }

    public static int clCompileProgram(long program, PointerBuffer device_list, ByteBuffer options, PointerBuffer input_headers, PointerBuffer header_include_names, CLProgramCallback pfn_notify, long user_data) {
        if (LWJGLUtil.CHECKS && header_include_names != null) {
            Checks.checkBuffer(header_include_names, input_headers.remaining());
        }
        return CL12.nclCompileProgram(program, device_list == null ? 0 : device_list.remaining(), MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(options), input_headers == null ? 0 : input_headers.remaining(), MemoryUtil.memAddressSafe(input_headers), MemoryUtil.memAddressSafe(header_include_names), pfn_notify == null ? 0L : pfn_notify.getPointer(), user_data);
    }

    public static int clCompileProgram(long program, PointerBuffer device_list, CharSequence options, PointerBuffer input_headers, PointerBuffer header_include_names, CLProgramCallback pfn_notify, long user_data) {
        if (LWJGLUtil.CHECKS && header_include_names != null) {
            Checks.checkBuffer(header_include_names, input_headers.remaining());
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int optionsEncoded = __buffer.stringParamASCII(options, true);
        return CL12.nclCompileProgram(program, device_list == null ? 0 : device_list.remaining(), MemoryUtil.memAddressSafe(device_list), __buffer.address(optionsEncoded), input_headers == null ? 0 : input_headers.remaining(), MemoryUtil.memAddressSafe(input_headers), MemoryUtil.memAddressSafe(header_include_names), pfn_notify == null ? 0L : pfn_notify.getPointer(), user_data);
    }

    public static int clCompileProgram(long program, PointerBuffer device_list, CharSequence options, long input_header, CharSequence header_include_name, CLProgramCallback pfn_notify, long user_data) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int optionsEncoded = __buffer.stringParamASCII(options, true);
        int input_headers = __buffer.pointerParam(input_header);
        ByteBuffer header_include_nameBuffer = MemoryUtil.memEncodeASCII(header_include_name);
        int header_include_names = __buffer.pointerParam(MemoryUtil.memAddress(header_include_nameBuffer));
        return CL12.nclCompileProgram(program, device_list == null ? 0 : device_list.remaining(), MemoryUtil.memAddressSafe(device_list), __buffer.address(optionsEncoded), 1, __buffer.address(input_headers), __buffer.address(header_include_names), pfn_notify == null ? 0L : pfn_notify.getPointer(), user_data);
    }

    public static native long nclLinkProgram(long var0, int var2, long var3, long var5, int var7, long var8, long var10, long var12, long var14);

    public static long nclLinkProgram(long context, int num_devices, long device_list, long options, int num_input_programs, long input_programs, long pfn_notify, long user_data) {
        long __functionAddress = CL12.getInstance().LinkProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL12.nclLinkProgram(context, num_devices, device_list, options, num_input_programs, input_programs, pfn_notify, user_data, __functionAddress);
    }

    public static long clLinkProgram(long context, int num_devices, ByteBuffer device_list, ByteBuffer options, int num_input_programs, ByteBuffer input_programs, CLProgramCallback pfn_notify, long user_data) {
        if (LWJGLUtil.CHECKS) {
            if (device_list != null) {
                Checks.checkBuffer((Buffer)device_list, num_devices << Pointer.POINTER_SHIFT);
            }
            Checks.checkNT1(options);
            if (input_programs != null) {
                Checks.checkBuffer((Buffer)input_programs, num_input_programs << Pointer.POINTER_SHIFT);
            }
        }
        return CL12.nclLinkProgram(context, num_devices, MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(options), num_input_programs, MemoryUtil.memAddressSafe(input_programs), pfn_notify == null ? 0L : pfn_notify.getPointer(), user_data);
    }

    public static long clLinkProgram(long context, PointerBuffer device_list, ByteBuffer options, PointerBuffer input_programs, CLProgramCallback pfn_notify, long user_data) {
        return CL12.nclLinkProgram(context, device_list == null ? 0 : device_list.remaining(), MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(options), input_programs == null ? 0 : input_programs.remaining(), MemoryUtil.memAddressSafe(input_programs), pfn_notify == null ? 0L : pfn_notify.getPointer(), user_data);
    }

    public static long clLinkProgram(long context, PointerBuffer device_list, CharSequence options, PointerBuffer input_programs, CLProgramCallback pfn_notify, long user_data) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int optionsEncoded = __buffer.stringParamASCII(options, true);
        return CL12.nclLinkProgram(context, device_list == null ? 0 : device_list.remaining(), MemoryUtil.memAddressSafe(device_list), __buffer.address(optionsEncoded), input_programs == null ? 0 : input_programs.remaining(), MemoryUtil.memAddressSafe(input_programs), pfn_notify == null ? 0L : pfn_notify.getPointer(), user_data);
    }

    public static long clLinkProgram(long context, PointerBuffer device_list, CharSequence options, long input_program, CLProgramCallback pfn_notify, long user_data) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int optionsEncoded = __buffer.stringParamASCII(options, true);
        int input_programs = __buffer.pointerParam(input_program);
        return CL12.nclLinkProgram(context, device_list == null ? 0 : device_list.remaining(), MemoryUtil.memAddressSafe(device_list), __buffer.address(optionsEncoded), 1, __buffer.address(input_programs), pfn_notify == null ? 0L : pfn_notify.getPointer(), user_data);
    }

    public static native int nclUnloadPlatformCompiler(long var0, long var2);

    public static int clUnloadPlatformCompiler(long platform) {
        long __functionAddress = CL12.getInstance().UnloadPlatformCompiler;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(platform);
        }
        return CL12.nclUnloadPlatformCompiler(platform, __functionAddress);
    }

    public static native int nclGetKernelArgInfo(long var0, int var2, int var3, long var4, long var6, long var8, long var10);

    public static int nclGetKernelArgInfo(long kernel, int arg_indx, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL12.getInstance().GetKernelArgInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(kernel);
        }
        return CL12.nclGetKernelArgInfo(kernel, arg_indx, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetKernelArgInfo(long kernel, int arg_indx, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL12.nclGetKernelArgInfo(kernel, arg_indx, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelArgInfo(long kernel, int arg_indx, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL12.nclGetKernelArgInfo(kernel, arg_indx, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelArgInfo(long kernel, int arg_indx, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL12.nclGetKernelArgInfo(kernel, arg_indx, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelArgInfo(long kernel, int arg_indx, int param_name, LongBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL12.nclGetKernelArgInfo(kernel, arg_indx, param_name, (param_value == null ? 0 : param_value.remaining()) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native int nclEnqueueFillBuffer(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, long var15, long var17);

    public static int nclEnqueueFillBuffer(long command_queue, long buffer, long pattern, long pattern_size, long offset, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL12.getInstance().EnqueueFillBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
        }
        return CL12.nclEnqueueFillBuffer(command_queue, buffer, pattern, pattern_size, offset, size, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueFillBuffer(long command_queue, long buffer, ByteBuffer pattern, long pattern_size, long offset, long size, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pattern, pattern_size);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL12.nclEnqueueFillBuffer(command_queue, buffer, MemoryUtil.memAddress(pattern), pattern_size, offset, size, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueFillBuffer(long command_queue, long buffer, ByteBuffer pattern, long offset, long size, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL12.nclEnqueueFillBuffer(command_queue, buffer, MemoryUtil.memAddress(pattern), pattern.remaining(), offset, size, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueFillImage(long var0, long var2, long var4, long var6, long var8, int var10, long var11, long var13, long var15);

    public static int nclEnqueueFillImage(long command_queue, long image, long fill_color, long origin, long region, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL12.getInstance().EnqueueFillImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(image);
        }
        return CL12.nclEnqueueFillImage(command_queue, image, fill_color, origin, region, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueFillImage(long command_queue, long image, ByteBuffer fill_color, ByteBuffer origin, ByteBuffer region, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL12.nclEnqueueFillImage(command_queue, image, MemoryUtil.memAddress(fill_color), MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueFillImage(long command_queue, long image, ByteBuffer fill_color, PointerBuffer origin, PointerBuffer region, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL12.nclEnqueueFillImage(command_queue, image, MemoryUtil.memAddress(fill_color), MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueMigrateMemObjects(long var0, int var2, long var3, long var5, int var7, long var8, long var10, long var12);

    public static int nclEnqueueMigrateMemObjects(long command_queue, int num_mem_objects, long mem_objects, long flags, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL12.getInstance().EnqueueMigrateMemObjects;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL12.nclEnqueueMigrateMemObjects(command_queue, num_mem_objects, mem_objects, flags, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueMigrateMemObjects(long command_queue, int num_mem_objects, ByteBuffer mem_objects, long flags, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)mem_objects, num_mem_objects << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL12.nclEnqueueMigrateMemObjects(command_queue, num_mem_objects, MemoryUtil.memAddress(mem_objects), flags, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueMigrateMemObjects(long command_queue, PointerBuffer mem_objects, long flags, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL12.nclEnqueueMigrateMemObjects(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), flags, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueMarkerWithWaitList(long var0, int var2, long var3, long var5, long var7);

    public static int nclEnqueueMarkerWithWaitList(long command_queue, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL12.getInstance().EnqueueMarkerWithWaitList;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL12.nclEnqueueMarkerWithWaitList(command_queue, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueMarkerWithWaitList(long command_queue, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL12.nclEnqueueMarkerWithWaitList(command_queue, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueMarkerWithWaitList(long command_queue, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL12.nclEnqueueMarkerWithWaitList(command_queue, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueBarrierWithWaitList(long var0, int var2, long var3, long var5, long var7);

    public static int nclEnqueueBarrierWithWaitList(long command_queue, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL12.getInstance().EnqueueBarrierWithWaitList;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL12.nclEnqueueBarrierWithWaitList(command_queue, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueBarrierWithWaitList(long command_queue, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL12.nclEnqueueBarrierWithWaitList(command_queue, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueBarrierWithWaitList(long command_queue, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL12.nclEnqueueBarrierWithWaitList(command_queue, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }
}

