/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class APPLEContextLoggingFunctions {
    public final long LogMessagesToSystemLogAPPLE;
    public final long LogMessagesToStdoutAPPLE;
    public final long LogMessagesToStderrAPPLE;

    public APPLEContextLoggingFunctions(FunctionProvider provider) {
        this.LogMessagesToSystemLogAPPLE = provider.getFunctionAddress("clLogMessagesToSystemLogAPPLE");
        this.LogMessagesToStdoutAPPLE = provider.getFunctionAddress("clLogMessagesToStdoutAPPLE");
        this.LogMessagesToStderrAPPLE = provider.getFunctionAddress("clLogMessagesToStderrAPPLE");
    }

    public static APPLEContextLoggingFunctions getInstance() {
        return CL.getICD().__APPLEContextLoggingFunctions;
    }

    static APPLEContextLoggingFunctions create(FunctionProvider provider) {
        APPLEContextLoggingFunctions funcs = new APPLEContextLoggingFunctions(provider);
        boolean supported = Checks.checkFunctions(funcs.LogMessagesToSystemLogAPPLE, funcs.LogMessagesToStdoutAPPLE, funcs.LogMessagesToStderrAPPLE);
        return supported ? funcs : null;
    }

    public static native void nclLogMessagesToSystemLogAPPLE(long var0, long var2, long var4, long var6, long var8);

    public static void nclLogMessagesToSystemLogAPPLE(long errstr, long private_info, long cb, long user_data) {
        long __functionAddress = APPLEContextLoggingFunctions.getInstance().LogMessagesToSystemLogAPPLE;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        APPLEContextLoggingFunctions.nclLogMessagesToSystemLogAPPLE(errstr, private_info, cb, user_data, __functionAddress);
    }

    public static void clLogMessagesToSystemLogAPPLE(ByteBuffer errstr, ByteBuffer private_info, long cb, ByteBuffer user_data) {
        APPLEContextLoggingFunctions.nclLogMessagesToSystemLogAPPLE(MemoryUtil.memAddress(errstr), MemoryUtil.memAddress(private_info), cb, MemoryUtil.memAddress(user_data));
    }

    public static native void nclLogMessagesToStdoutAPPLE(long var0, long var2, long var4, long var6, long var8);

    public static void nclLogMessagesToStdoutAPPLE(long errstr, long private_info, long cb, long user_data) {
        long __functionAddress = APPLEContextLoggingFunctions.getInstance().LogMessagesToStdoutAPPLE;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        APPLEContextLoggingFunctions.nclLogMessagesToStdoutAPPLE(errstr, private_info, cb, user_data, __functionAddress);
    }

    public static void clLogMessagesToStdoutAPPLE(ByteBuffer errstr, ByteBuffer private_info, long cb, ByteBuffer user_data) {
        APPLEContextLoggingFunctions.nclLogMessagesToStdoutAPPLE(MemoryUtil.memAddress(errstr), MemoryUtil.memAddress(private_info), cb, MemoryUtil.memAddress(user_data));
    }

    public static native void nclLogMessagesToStderrAPPLE(long var0, long var2, long var4, long var6, long var8);

    public static void nclLogMessagesToStderrAPPLE(long errstr, long private_info, long cb, long user_data) {
        long __functionAddress = APPLEContextLoggingFunctions.getInstance().LogMessagesToStderrAPPLE;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        APPLEContextLoggingFunctions.nclLogMessagesToStderrAPPLE(errstr, private_info, cb, user_data, __functionAddress);
    }

    public static void clLogMessagesToStderrAPPLE(ByteBuffer errstr, ByteBuffer private_info, long cb, ByteBuffer user_data) {
        APPLEContextLoggingFunctions.nclLogMessagesToStderrAPPLE(MemoryUtil.memAddress(errstr), MemoryUtil.memAddress(private_info), cb, MemoryUtil.memAddress(user_data));
    }
}

