/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.ALContext;
import org.lwjgl.openal.ALDevice;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class AL {
    private static FunctionProvider functionProvider;
    private static ALContext processContext;
    private static final ThreadLocal<ALContext> threadContext;

    private AL() {
    }

    static void init() {
        functionProvider = new FunctionProvider.Default(){
            private final long alGetProcAddress = ALC.getFunctionProvider().getFunctionAddress("alGetProcAddress");

            @Override
            public long getFunctionAddress(CharSequence functionName) {
                APIBuffer __buffer = APIUtil.apiBuffer();
                __buffer.stringParamASCII(functionName, true);
                long address = AL10.nalGetProcAddress(__buffer.address(), this.alGetProcAddress);
                if (address == 0L) {
                    LWJGLUtil.log("Failed to locate address for AL function " + functionName);
                }
                return address;
            }

            @Override
            protected void destroy() {
            }
        };
    }

    static void destroy() {
        if (functionProvider == null) {
            return;
        }
        AL.setCurrentProcess(null);
        functionProvider.release();
        functionProvider = null;
    }

    public static FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    static void setCurrentProcess(ALContext context) {
        processContext = context;
        threadContext.set(null);
    }

    static void setCurrentThread(ALContext context) {
        threadContext.set(context);
    }

    public static ALContext getCurrentContext() {
        ALContext context = threadContext.get();
        return context != null ? context : processContext;
    }

    public static ALCapabilities getCapabilities() {
        return AL.getCurrentContext().getCapabilities();
    }

    public static ALCapabilities createCapabilities(long device) {
        int majorVersion = ALC10.alcGetInteger(device, 4096);
        int minorVersion = ALC10.alcGetInteger(device, 4097);
        int[][] AL_VERSIONS = new int[][]{{0, 1}};
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        for (int major = 1; major <= AL_VERSIONS.length; ++major) {
            int[] minors;
            for (int minor : minors = AL_VERSIONS[major - 1]) {
                if (major >= majorVersion && (major != majorVersion || minor > minorVersion)) continue;
                supportedExtensions.add("OpenAL" + Integer.toString(major) + Integer.toString(minor));
            }
        }
        long GetString = functionProvider.getFunctionAddress("alGetString");
        long IsExtensionPresent = functionProvider.getFunctionAddress("alIsExtensionPresent");
        if (GetString == 0L || IsExtensionPresent == 0L) {
            throw new IllegalStateException("Core OpenAL functions could not be found. Make sure that OpenAL has been loaded.");
        }
        String extensionsString = MemoryUtil.memDecodeUTF8(Checks.checkPointer(AL10.nalGetString(45060, GetString)));
        APIBuffer __buffer = APIUtil.apiBuffer();
        StringTokenizer tokenizer = new StringTokenizer(extensionsString);
        while (tokenizer.hasMoreTokens()) {
            String extName = tokenizer.nextToken();
            __buffer.reset().stringParamASCII(extName, true);
            if (!AL10.nalIsExtensionPresent(__buffer.address(), IsExtensionPresent)) continue;
            supportedExtensions.add(extName);
        }
        return new ALCapabilities(AL.getFunctionProvider(), supportedExtensions);
    }

    static <T> T checkExtension(String extension, T functions, boolean supported) {
        if (supported) {
            return functions;
        }
        LWJGLUtil.log("[AL] " + extension + " was reported as available but an entry point is missing.");
        return null;
    }

    public static void destroy(ALContext alContext) {
        ALDevice device = alContext.getDevice();
        alContext.destroy();
        device.destroy();
    }

    static {
        threadContext = new ThreadLocal();
    }
}

