/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class GLFWimage
implements Pointer {
    public static final int SIZEOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int PIXELS;
    private final ByteBuffer struct;

    public GLFWimage() {
        this(GLFWimage.malloc());
    }

    public GLFWimage(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setWidth(int width) {
        GLFWimage.width(this.struct, width);
    }

    public void setHeight(int height) {
        GLFWimage.height(this.struct, height);
    }

    public void setPixels(long pixels) {
        GLFWimage.pixels(this.struct, pixels);
    }

    public void setPixels(ByteBuffer pixels) {
        GLFWimage.pixels(this.struct, pixels);
    }

    public int getWidth() {
        return GLFWimage.width(this.struct);
    }

    public int getHeight() {
        return GLFWimage.height(this.struct);
    }

    public long getPixels() {
        return GLFWimage.pixels(this.struct);
    }

    public ByteBuffer getPixels(int byteLen) {
        return GLFWimage.pixels(this.struct, byteLen);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int width, int height, ByteBuffer pixels) {
        ByteBuffer glfwimage = GLFWimage.malloc();
        GLFWimage.width(glfwimage, width);
        GLFWimage.height(glfwimage, height);
        GLFWimage.pixels(glfwimage, pixels);
        return glfwimage;
    }

    public static void width(ByteBuffer glfwimage, int width) {
        glfwimage.putInt(glfwimage.position() + WIDTH, width);
    }

    public static void height(ByteBuffer glfwimage, int height) {
        glfwimage.putInt(glfwimage.position() + HEIGHT, height);
    }

    public static void pixels(ByteBuffer glfwimage, long pixels) {
        PointerBuffer.put(glfwimage, glfwimage.position() + PIXELS, pixels);
    }

    public static void pixels(ByteBuffer glfwimage, ByteBuffer pixels) {
        GLFWimage.pixels(glfwimage, MemoryUtil.memAddressSafe(pixels));
    }

    public static int width(ByteBuffer glfwimage) {
        return glfwimage.getInt(glfwimage.position() + WIDTH);
    }

    public static int height(ByteBuffer glfwimage) {
        return glfwimage.getInt(glfwimage.position() + HEIGHT);
    }

    public static long pixels(ByteBuffer glfwimage) {
        return PointerBuffer.get(glfwimage, glfwimage.position() + PIXELS);
    }

    public static ByteBuffer pixels(ByteBuffer glfwimage, int byteLen) {
        return MemoryUtil.memByteBuffer(GLFWimage.pixels(glfwimage), byteLen);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(3);
        SIZEOF = GLFWimage.offsets(MemoryUtil.memAddress(offsets));
        WIDTH = offsets.get(0);
        HEIGHT = offsets.get(1);
        PIXELS = offsets.get(2);
    }
}

