/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class GLFWgammaramp
implements Pointer {
    public static final int SIZEOF;
    public static final int RED;
    public static final int GREEN;
    public static final int BLUE;
    public static final int SIZE;
    private final ByteBuffer struct;

    public GLFWgammaramp() {
        this(GLFWgammaramp.malloc());
    }

    public GLFWgammaramp(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setRed(long red) {
        GLFWgammaramp.red(this.struct, red);
    }

    public void setRed(ByteBuffer red) {
        GLFWgammaramp.red(this.struct, red);
    }

    public void setGreen(long green) {
        GLFWgammaramp.green(this.struct, green);
    }

    public void setGreen(ByteBuffer green) {
        GLFWgammaramp.green(this.struct, green);
    }

    public void setBlue(long blue) {
        GLFWgammaramp.blue(this.struct, blue);
    }

    public void setBlue(ByteBuffer blue) {
        GLFWgammaramp.blue(this.struct, blue);
    }

    public void setSize(int size) {
        GLFWgammaramp.size(this.struct, size);
    }

    public long getRed() {
        return GLFWgammaramp.red(this.struct);
    }

    public ByteBuffer getRed(int byteLen) {
        return GLFWgammaramp.red(this.struct, byteLen);
    }

    public long getGreen() {
        return GLFWgammaramp.green(this.struct);
    }

    public ByteBuffer getGreen(int byteLen) {
        return GLFWgammaramp.green(this.struct, byteLen);
    }

    public long getBlue() {
        return GLFWgammaramp.blue(this.struct);
    }

    public ByteBuffer getBlue(int byteLen) {
        return GLFWgammaramp.blue(this.struct, byteLen);
    }

    public int getSize() {
        return GLFWgammaramp.size(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(ByteBuffer red, ByteBuffer green, ByteBuffer blue, int size) {
        ByteBuffer glfwgammaramp = GLFWgammaramp.malloc();
        GLFWgammaramp.red(glfwgammaramp, red);
        GLFWgammaramp.green(glfwgammaramp, green);
        GLFWgammaramp.blue(glfwgammaramp, blue);
        GLFWgammaramp.size(glfwgammaramp, size);
        return glfwgammaramp;
    }

    public static void red(ByteBuffer glfwgammaramp, long red) {
        PointerBuffer.put(glfwgammaramp, glfwgammaramp.position() + RED, red);
    }

    public static void red(ByteBuffer glfwgammaramp, ByteBuffer red) {
        GLFWgammaramp.red(glfwgammaramp, MemoryUtil.memAddressSafe(red));
    }

    public static void green(ByteBuffer glfwgammaramp, long green) {
        PointerBuffer.put(glfwgammaramp, glfwgammaramp.position() + GREEN, green);
    }

    public static void green(ByteBuffer glfwgammaramp, ByteBuffer green) {
        GLFWgammaramp.green(glfwgammaramp, MemoryUtil.memAddressSafe(green));
    }

    public static void blue(ByteBuffer glfwgammaramp, long blue) {
        PointerBuffer.put(glfwgammaramp, glfwgammaramp.position() + BLUE, blue);
    }

    public static void blue(ByteBuffer glfwgammaramp, ByteBuffer blue) {
        GLFWgammaramp.blue(glfwgammaramp, MemoryUtil.memAddressSafe(blue));
    }

    public static void size(ByteBuffer glfwgammaramp, int size) {
        glfwgammaramp.putInt(glfwgammaramp.position() + SIZE, size);
    }

    public static long red(ByteBuffer glfwgammaramp) {
        return PointerBuffer.get(glfwgammaramp, glfwgammaramp.position() + RED);
    }

    public static ByteBuffer red(ByteBuffer glfwgammaramp, int byteLen) {
        return MemoryUtil.memByteBuffer(GLFWgammaramp.red(glfwgammaramp), byteLen);
    }

    public static long green(ByteBuffer glfwgammaramp) {
        return PointerBuffer.get(glfwgammaramp, glfwgammaramp.position() + GREEN);
    }

    public static ByteBuffer green(ByteBuffer glfwgammaramp, int byteLen) {
        return MemoryUtil.memByteBuffer(GLFWgammaramp.green(glfwgammaramp), byteLen);
    }

    public static long blue(ByteBuffer glfwgammaramp) {
        return PointerBuffer.get(glfwgammaramp, glfwgammaramp.position() + BLUE);
    }

    public static ByteBuffer blue(ByteBuffer glfwgammaramp, int byteLen) {
        return MemoryUtil.memByteBuffer(GLFWgammaramp.blue(glfwgammaramp), byteLen);
    }

    public static int size(ByteBuffer glfwgammaramp) {
        return glfwgammaramp.getInt(glfwgammaramp.position() + SIZE);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(4);
        SIZEOF = GLFWgammaramp.offsets(MemoryUtil.memAddress(offsets));
        RED = offsets.get(0);
        GREEN = offsets.get(1);
        BLUE = offsets.get(2);
        SIZE = offsets.get(3);
    }
}

