/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.awt.Color;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import render.Texture;

public class GLSLFunctions {
    public static int clamp(int x, int min, int max) {
        if (x < min) {
            System.err.println("min clamp");
            return min;
        }
        if (x > max) {
            System.err.println("max clamp");
            return max;
        }
        return x;
    }

    public static float mod(float x, float y) {
        return x - y * (float)Math.floor(x / y);
    }

    public static Vector3f texture(Texture tex, Vector2f p) {
        float px = GLSLFunctions.mod(p.x, 1.0f);
        float py = GLSLFunctions.mod(p.y, 1.0f);
        int cx = (int)(px * (float)tex.image.getWidth());
        int cy = (int)((float)tex.image.getHeight() * py);
        Color c = new Color(tex.image.getRGB(GLSLFunctions.clamp(cx, 0, tex.image.getWidth() - 1), GLSLFunctions.clamp(cy, 0, tex.image.getHeight() - 1)));
        Vector3f val = new Vector3f(c.getRed(), c.getGreen(), c.getBlue());
        val.scale(0.003921569f);
        return val;
    }

    public static float pyrField(Vector2f p, float base, float h) {
        float pyx = Math.min(GLSLFunctions.mod(p.x, base), base - GLSLFunctions.mod(p.x, base));
        float pyy = Math.min(GLSLFunctions.mod(p.y, base), base - GLSLFunctions.mod(p.y, base));
        return Math.min(pyx, pyy) * h;
    }

    public static float min(float a, float b) {
        return Math.min(a, b);
    }

    public static float max(float a, float b) {
        return Math.max(a, b);
    }

    public static Vector3f max(Vector3f a, float b) {
        return new Vector3f(GLSLFunctions.max(a.x, b), GLSLFunctions.max(a.y, b), GLSLFunctions.max(a.z, b));
    }

    public static float length(Vector3f a) {
        return a.length();
    }

    public static float sdBox(Vector3f p, Vector3f b) {
        Vector3f d = new Vector3f(Math.abs(p.x) - b.x, Math.abs(p.y) - b.y, Math.abs(p.z) - b.z);
        return GLSLFunctions.min(GLSLFunctions.max(d.x, GLSLFunctions.max(d.y, d.z)), 0.0f) + GLSLFunctions.length(GLSLFunctions.max(d, 0.0f));
    }

    public static float length(Vector2f a) {
        return a.length();
    }

    public static float sdTorus(Vector3f p, Vector2f t) {
        Vector2f q = new Vector2f(GLSLFunctions.length(new Vector2f(p.x, p.z)) - t.x, p.y);
        return GLSLFunctions.length(q) - t.y;
    }

    public static float abs(float a) {
        return Math.abs(a);
    }

    public static float trunc(float a) {
        if (a >= 0.0f) {
            return (float)Math.floor(a);
        }
        return (float)Math.ceil(a);
    }

    public static float sign(float a) {
        return Math.signum(a);
    }

    public static float sin(float a) {
        return (float)Math.sin(a);
    }

    public static float sin(double a) {
        return (float)Math.sin(a);
    }

    public static float cos(float a) {
        return (float)Math.cos(a);
    }

    public static float cos(double a) {
        return (float)Math.cos(a);
    }

    public static float mix(float x, float y, float a) {
        return x * (1.0f - a) + y * a;
    }

    public static float clamp(float x, float minVal, float maxVal) {
        return GLSLFunctions.min(GLSLFunctions.max(x, minVal), maxVal);
    }

    public static float smoothstep(float edge0, float edge1, float x) {
        float t = GLSLFunctions.clamp((x - edge0) / (edge1 - edge0), 0.0f, 1.0f);
        return t * t * (3.0f - 2.0f * t);
    }

    public static Vector3f reflect(Vector3f i, Vector3f n) {
        n = new Vector3f(n);
        n.normalize();
        i = new Vector3f(i);
        i.normalize();
        n.scale(2.0f * n.dot(i));
        i.sub(n);
        return i;
    }

    public static float sdCylinder(Vector3f p, Vector3f c) {
        return GLSLFunctions.length(new Vector2f(p.x - c.x, p.z - c.y)) - c.z;
    }

    public static float sdHexPrism(Vector3f p, Vector2f h) {
        Vector3f q = GLSLFunctions.abs(p);
        return GLSLFunctions.max(q.z - h.y, GLSLFunctions.max((double)q.x * 0.866025 + (double)q.y * 0.5, q.y) - h.x);
    }

    private static Vector3f abs(Vector3f p) {
        return new Vector3f(GLSLFunctions.abs(p.x), GLSLFunctions.abs(p.y), GLSLFunctions.abs(p.z));
    }

    private static float max(double d, float y) {
        return GLSLFunctions.max((float)d, y);
    }

    public static float sphere(Vector3f p, float r) {
        return GLSLFunctions.length(p) - r;
    }
}

