/*
 * Decompiled with CFR 0.152.
 */
package time.as.tool;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Flea
extends JPanel
implements KeyListener {
    int panelWidth = 225;
    int panelHeight = 900;
    Color veryLightGray = new Color(200, 200, 200);
    int gameWidth = 75;
    int gameHeight = 300;
    int posX = 36;
    int posY = 250;
    int jumpPermit = 6;
    int jumpStepLeft = 0;
    int permittedFramesToStop = 15;
    int framesCurrentlyStill;
    ArrayList<Point> pastSelves = new ArrayList();
    int dirX;
    int currentLevel = 0;
    int transitionOpening = 0;
    int slowModePress;
    int leftPress;
    int rightPress;
    int jumpPress;
    int aPress;
    int dPress;
    int wPress;
    int lPress;
    int rPress;
    int upPress;
    JFrame frame;
    String relativePath = new File("").getAbsolutePath();
    BufferedImage level;
    BufferedImage collisionField = new BufferedImage(75, 300, 1);
    BufferedImage drawField = new BufferedImage(75, 300, 1);
    BufferedImage[] levels;
    private static Clip clip = null;

    public static void main(String[] args) {
        new Flea();
    }

    public Flea() {
        this.setPreferredSize(new Dimension(this.panelWidth, this.panelHeight));
        this.frame = new JFrame("Flea");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setContentPane(this);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        this.frame.addKeyListener(this);
        try {
            this.levels = new BufferedImage[5];
            this.levels[0] = ImageIO.read(new File(this.relativePath + "\\img\\lvl1.png"));
            this.levels[1] = ImageIO.read(new File(this.relativePath + "\\img\\lvl2.png"));
            this.levels[2] = ImageIO.read(new File(this.relativePath + "\\img\\lvl3.png"));
            this.levels[3] = ImageIO.read(new File(this.relativePath + "\\img\\end.png"));
            this.levels[4] = ImageIO.read(new File(this.relativePath + "\\img\\cred.jpg"));
            this.level = this.levels[0];
            this.playSound("rainloop.wav", true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.playSound("drum.wav", false);
        this.startGame();
    }

    private void playSound(String soundName, boolean loop) {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new File(this.relativePath + "\\snd\\" + soundName));
            Clip jumpSound = AudioSystem.getClip();
            jumpSound.open(audioInputStream);
            if (loop) {
                jumpSound.loop(-1);
            }
            jumpSound.start();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    private void startGame() {
        while (true) {
            if (this.transitionOpening >= this.gameHeight) {
                this.moveChar();
            }
            this.repaint();
            try {
                if (this.transitionOpening < this.gameHeight) {
                    Thread.sleep(8L);
                    continue;
                }
                Thread.sleep(33 + this.slowModePress * 30);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void moveChar() {
        this.jumpPress = this.wPress > 0 || this.upPress > 0 ? 1 : 0;
        this.rightPress = this.rPress > 0 || this.dPress > 0 ? 1 : 0;
        this.leftPress = this.lPress > 0 || this.aPress > 0 ? 1 : 0;
        this.dirX = this.rightPress - this.leftPress;
        int jump = this.rightPress > 0 || this.leftPress > 0 ? 1 : 0;
        jump += this.jumpPress;
        this.pastSelves.add(new Point(this.posX, this.posY));
        this.framesCurrentlyStill = this.dirX == 0 || this.collideWithMap(this.posX + this.dirX, this.posY) ? --this.framesCurrentlyStill : this.permittedFramesToStop;
        if (this.framesCurrentlyStill < 1) {
            this.pastSelves.clear();
        }
        if (!this.collideWithMap(this.posX + this.dirX, this.posY)) {
            this.posX += this.dirX;
        }
        this.posX = Math.floorMod(this.posX, this.gameWidth);
        if (jump > 0) {
            if (this.jumpStepLeft > 0) {
                if (!this.collideWithMap(this.posX, this.posY - 1)) {
                    --this.posY;
                    --this.jumpStepLeft;
                } else {
                    this.jumpStepLeft = 0;
                }
            } else if (this.isGroundBelow(this.posX, this.posY) && !this.collideWithMap(this.posX, this.posY - 1)) {
                this.jumpStepLeft = this.jumpPermit;
                --this.posY;
                this.playSound("jump.wav", false);
            } else {
                this.jumpStepLeft = 0;
            }
        } else {
            this.jumpStepLeft = 0;
        }
        if (!this.collideWithMap(this.posX, this.posY + 1) && this.jumpStepLeft == 0) {
            ++this.posY;
        }
    }

    public boolean isGroundBelow(int x, int y) {
        if (this.collideWithMap(this.posX, this.posY + 1)) {
            return true;
        }
        if (this.collideWithMap(this.posX - 1, this.posY + 1) && !this.collideWithMap(this.posX - 1, this.posY)) {
            return true;
        }
        return this.collideWithMap(this.posX + 1, this.posY + 1) && !this.collideWithMap(this.posX + 1, this.posY);
    }

    public boolean collideWithMap(int x, int y) {
        if (this.collisionField.getRGB(Math.floorMod(x, this.gameWidth), y) == -256) {
            this.nextLevel();
        }
        return this.collisionField.getRGB(Math.floorMod(x, this.gameWidth), y) != -1;
    }

    private void nextLevel() {
        this.posX = 36;
        this.posY = 250;
        ++this.currentLevel;
        this.level = this.levels[this.currentLevel];
        this.transitionOpening = 0;
        this.pastSelves.clear();
        this.playSound("drum.wav", false);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Color colorTemp = new Color(0, 0, 0);
        if (this.level != null) {
            Graphics2D pallett = this.drawField.createGraphics();
            if (this.transitionOpening < this.gameHeight) {
                pallett.setColor(Color.WHITE);
                pallett.fillRect(0, 0, this.gameWidth, this.gameHeight);
                for (int x = 0; x < this.level.getWidth(); ++x) {
                    int pixel;
                    int n = 0;
                    for (int y = this.level.getHeight() - this.transitionOpening - 1; y > -1; --y) {
                        pixel = this.level.getRGB(x, y);
                        if (pixel == -1) continue;
                        pallett.setColor(new Color(pixel));
                        pallett.fillRect(x, this.gameHeight - 1 - this.transitionOpening - n, 1, 1);
                        ++n;
                    }
                    for (int t = 0; t < this.transitionOpening; ++t) {
                        pixel = this.level.getRGB(x, this.gameHeight - 1 - t);
                        pallett.setColor(new Color(pixel));
                        pallett.fillRect(x, this.gameHeight - 1 - t, 1, 1);
                    }
                }
                ++this.transitionOpening;
            } else {
                pallett.drawImage((Image)this.level, 0, 0, null);
                pallett.setColor(this.veryLightGray);
                for (int i = this.pastSelves.size() - 1; i > 0; i -= 4) {
                    Point p = this.pastSelves.get(i);
                    pallett.fillRect(p.x, p.y, 1, 1);
                }
                this.collisionField.createGraphics().drawImage((Image)this.drawField, 0, 0, null);
            }
            pallett.setColor(Color.BLACK);
            pallett.fillRect(this.posX, this.posY, 1, 1);
            g.drawImage(this.drawField.getScaledInstance(225, 900, 2), 0, 0, null);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 65) {
            this.aPress = 1;
        }
        if (e.getKeyCode() == 37) {
            this.lPress = 1;
        }
        if (e.getKeyCode() == 68) {
            this.dPress = 1;
        }
        if (e.getKeyCode() == 39) {
            this.rPress = 1;
        }
        if (e.getKeyCode() == 87) {
            this.wPress = 1;
        }
        if (e.getKeyCode() == 38) {
            this.upPress = 1;
        }
        if (e.getKeyCode() == 16) {
            this.slowModePress = 1;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 65) {
            this.aPress = 0;
        }
        if (e.getKeyCode() == 37) {
            this.lPress = 0;
        }
        if (e.getKeyCode() == 68) {
            this.dPress = 0;
        }
        if (e.getKeyCode() == 39) {
            this.rPress = 0;
        }
        if (e.getKeyCode() == 87) {
            this.wPress = 0;
        }
        if (e.getKeyCode() == 38) {
            this.upPress = 0;
        }
        if (e.getKeyCode() == 16) {
            this.slowModePress = 0;
        }
    }
}

