/*
 * Decompiled with CFR 0.152.
 */
package com.petterroea.neural;

import com.petterroea.neural.INode;
import java.util.LinkedList;

public class AdditionNode
implements INode {
    private LinkedList<INode> inputs = new LinkedList();
    private LinkedList<INode> outputs = new LinkedList();
    private float value = 0.0f;
    private boolean hasSimulated = false;

    @Override
    public boolean canConnectInput() {
        return true;
    }

    @Override
    public void connectInput(INode n) {
        this.inputs.add(n);
    }

    @Override
    public void disconnectInput(INode n) {
        this.inputs.remove(n);
    }

    @Override
    public int getNeededInputs() {
        return this.inputs.size() > 0 ? 0 : 1;
    }

    @Override
    public boolean canSimulate() {
        for (INode node : this.inputs) {
            if (node.hasSimulated()) continue;
            return false;
        }
        return this.inputs.size() > 0 && !this.hasSimulated();
    }

    @Override
    public void simulate() {
        if (this.canSimulate()) {
            this.value = 0.0f;
            for (INode node : this.inputs) {
                this.value += node.getOutput();
            }
            this.hasSimulated = true;
            for (INode outputNode : this.outputs) {
                if (!outputNode.canSimulate()) continue;
                outputNode.simulate();
            }
        }
    }

    @Override
    public boolean hasSimulated() {
        return this.hasSimulated;
    }

    @Override
    public void connectOutput(INode n) {
        this.outputs.add(n);
    }

    @Override
    public boolean canConnectOutput() {
        return true;
    }

    @Override
    public void disconnectOutput(INode n) {
        this.outputs.remove(n);
    }

    @Override
    public float getOutput() {
        return this.value;
    }

    @Override
    public void reset() {
        this.hasSimulated = false;
    }

    @Override
    public int getNeededOutputs() {
        return this.outputs.size() > 0 ? 0 : 1;
    }
}

