package com.petterroea.neural;

import java.util.LinkedList;

public class LargestNumberNode implements INode{
	private LinkedList<INode> inputs = new LinkedList<INode>();
	private LinkedList<INode> outputs = new LinkedList<INode>();
	private float value = 0f;
	private boolean hasSimulated = false;
	@Override
	public boolean canConnectInput() {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public void connectInput(INode n) {
		inputs.add(n);
	}

	@Override
	public void disconnectInput(INode n) {
		inputs.remove(n);
	}

	@Override
	public int getNeededInputs() {
		return inputs.size() > 0 ? 0 : 1;
	}

	@Override
	public boolean canSimulate() {
		for(INode node : inputs)
		{
			if(!node.hasSimulated())
			{
				return false;
			}
		}
		return inputs.size() > 0 && !hasSimulated();
	}

	@Override
	public void simulate() {
		value = 1000000f;
		for(INode node : inputs)
		{
			if(value > node.getOutput()) {
				value = node.getOutput();
			}
		}
		hasSimulated = true;
		for(INode outputNode : outputs)
		{
			if(outputNode.canSimulate()) {
				outputNode.simulate();
			}
		}
	}

	@Override
	public boolean hasSimulated() {
		// TODO Auto-generated method stub
		return hasSimulated;
	}

	@Override
	public void connectOutput(INode n) {
		outputs.add(n);
	}

	@Override
	public boolean canConnectOutput() {
		return true;
	}

	@Override
	public void disconnectOutput(INode n) {
		outputs.remove(n);
	}

	@Override
	public float getOutput() {
		// TODO Auto-generated method stub
		return value;
	}

	@Override
	public void reset() {
		hasSimulated = false;
	}

	@Override
	public int getNeededOutputs() {
		return outputs.size() > 0 ? 0 : 1;
	}

}
