package com.petterroea.kartering.map;

public class Tile {
	public enum TileType
	{
		TOPLEFT,
		HORIZONTAL,
		TOPRIGHT,
		VERTICAL,
		BOTTOMRIGHT,
		BOTTOMLEFT,
		CROSS,
		BLANK
	}
	private TileType type;
	public Tile(TileType type)
	{
		this.type = type;
	}
	public Tile(String text)
	{	
		if(text.equals(".")) {
			type = TileType.BLANK;
		} else if(text.equals("/")) {
			type = TileType.TOPLEFT;
		} else if(text.equals("-")) {
			type = TileType.HORIZONTAL;
		} else if(text.equals("`")) {
			type = TileType.TOPRIGHT;
		} else if(text.equals("|")) {
			type = TileType.VERTICAL;
		} else if(text.equals(",")) {
			type = TileType.BOTTOMRIGHT;
		} else if(text.equals("\\")) {
			type = TileType.BOTTOMLEFT;
		} else if(text.equals("+")) {
			type = TileType.CROSS;
		}
	}
	public TileType getType()
	{
		return type;
	}
	
}
