// Generated by CoffeeScript 1.9.0
(function() {
  var Vec2, accellerate, calculateAngleBetweenVectors, calculateNextMove, client, connectToServer, convertToDegrees, currentTarget, decellerate, drift, exports, formatMessage, getPositionOfNextTile, initData, isInsideTarget, net, nextTarget, powerUp, turnLeft, turnRight;

  net = require('net');

  Vec2 = require('rg.vec2');

  exports = module.exports = {};


  /*
   */

  initData = null;

  currentTarget = null;

  nextTarget = null;

  connectToServer = false;

  console.log('Connecting to server');

  client = net.connect({
    port: 31337
  }, function() {
    console.log('Connected to server');
    return client.write('1\n');
  });

  client.on('data', function(data) {
    console.log('client on data');
    console.log(data.toString());
    data = JSON.parse(data.toString());
    console.log(data);
    if (initData === null) {
      console.log('first run');
      initData = data;
      return client.write('1\n');
    } else {
      console.log('going normal route');
      return client.write(formatMessage(calculateNextMove(data)));
    }
  });

  client.on('end', function() {
    return console.log('disconnected from server');
  });

  calculateNextMove = function(data) {
    var commands, goalPos, goalVector, myPos, myVector, theAngleInDegrees, x, y;
    myPos = data.cars[initData.id];
    commands = accellerate([]);
    if (currentTarget == null) {
      currentTarget = 0;
    }
    console.log("currentTarget is set to " + currentTarget);
    nextTarget = currentTarget + 1;
    goalPos = getPositionOfNextTile(nextTarget);
    if (isInsideTarget(myPos, goalPos)) {
      console.log("We hit the target! Let's pick another one!");
      if (currentTarget === initData.map.path.length - 2) {
        console.log('were at the end of the map');
        currentTarget = 1;
      } else {
        console.log('still following the path');
        currentTarget = nextTarget;
      }
      calculateNextMove(data);
      return commands;
    }
    myVector = new Vec2(myPos.velocity.x, myPos.velocity.y);
    x = goalPos.center_x - myPos.pos.x;
    y = goalPos.center_y - myPos.pos.y;
    goalVector = new Vec2(x, y);
    theAngleInDegrees = calculateAngleBetweenVectors(myVector, goalVector, myPos);
    console.log('theAngleInDegrees');
    console.log(theAngleInDegrees);
    if (theAngleInDegrees < 5 && theAngleInDegrees > -5) {
      console.log('going straight');
      return commands;
    }
    if (theAngleInDegrees < 0) {
      console.log('time to turn left');
      commands = turnLeft(commands);
      return commands;
    } else if (theAngleInDegrees >= 0) {
      console.log('time to turn right');
      commands = turnRight(commands);
      console.log(commands);
      return commands;
    }
  };

  calculateAngleBetweenVectors = function(myVector, goalVector, myCar) {
    var directionVec, finalAngle, modifier, normalizedGoalVector;
    console.log('myVector');
    console.log(myVector);
    console.log('myVector normalized');
    myVector.normalize();
    console.log(myVector);
    console.log('myVector angle');
    console.log(myVector.angle() * (180 / Math.PI));
    console.log('goalVector');
    console.log(goalVector);
    console.log('goalVector normalized');
    normalizedGoalVector = goalVector.copy();
    normalizedGoalVector.normalize();
    console.log(normalizedGoalVector);
    console.log('angle of normalizedGoalVector');
    console.log(convertToDegrees(normalizedGoalVector.angle()));
    if (goalVector.y >= 0 && goalVector.x >= 0) {
      modifier = 1;
    }
    if (goalVector.y >= 0 && goalVector.x <= 0) {
      modifier = 1;
    }
    if (goalVector.y < 0 && goalVector.x < 0) {
      modifier = -1;
    }
    if (goalVector.y < 0 && goalVector.x > 0) {
      modifier = -1;
    }
    console.log('directionVec');
    directionVec = new Vec2(myCar.direction.x, myCar.direction.y);
    console.log(directionVec);
    console.log(convertToDegrees(directionVec.angle()));
    console.log('goalVector angle');
    goalVector.normalize();
    console.log(goalVector);
    console.log(goalVector.angle() * (180 / Math.PI));
    finalAngle = convertToDegrees((goalVector.angle()) - directionVec.angle());
    finalAngle = finalAngle % 360;
    if (finalAngle < 0) {
      finalAngle = finalAngle + 360;
    }
    console.log("final needed angle shift " + finalAngle);
    return finalAngle;
  };

  getPositionOfNextTile = function(nextTarget) {
    var result;
    result = initData.map.path[nextTarget];
    result.x = initData.map.tile_width * initData.map.path[nextTarget].tile_x;
    result.y = initData.map.tile_height * initData.map.path[nextTarget].tile_y;
    result.center_x = result.x + initData.map.tile_width / 2;
    result.center_y = result.y + initData.map.tile_height / 2;
    return result;
  };

  isInsideTarget = function(myPos, goalPos) {
    var isWithinX, isWithinY, map;
    map = initData.map;
    isWithinX = function() {
      return myPos.pos.x > goalPos.x && myPos.pos.x < goalPos.x + map.tile_width;
    };
    isWithinY = function() {
      return myPos.pos.y > goalPos.y && myPos.pos.y < goalPos.y + map.tile_height;
    };
    if (isWithinX() && isWithinY()) {
      return true;
    } else {
      return false;
    }
  };

  convertToDegrees = function(radians) {
    return radians * (180 / Math.PI);
  };

  accellerate = function(commands) {
    commands[0] = 1;
    return commands;
  };

  decellerate = function(commands) {
    commands[1] = 1;
    return commands;
  };

  turnLeft = function(commands) {
    commands[2] = 1;
    return commands;
  };

  turnRight = function(commands) {
    commands[3] = 1;
    return commands;
  };

  drift = function(commands) {
    commands[4] = 1;
    return commands;
  };

  powerUp = function(commands) {
    commands[5] = 1;
    return commands;
  };

  formatMessage = function(commands) {
    var result;
    console.log('formatMessage');
    console.log(commands);
    result = 0;
    if (commands[0]) {
      result += 1;
    }
    if (commands[1]) {
      result += 2;
    }
    if (commands[2]) {
      result += 4;
    }
    if (commands[3]) {
      result += 8;
    }
    if (commands[4]) {
      result += 16;
    }
    if (commands[5]) {
      result += 32;
    }
    return result + '\n';
  };

  exports.getter = function(name) {
    if (name === 'initData') {
      return initData;
    } else if (name === 'currentTarget') {
      return currentTarget;
    } else if (name === 'nextTarget') {
      return nextTarget;
    }
  };

  exports.setter = function(value, name) {
    if (name === 'initData') {
      return initData = value;
    } else if (name === 'currentTarget') {
      return currentTarget = value;
    } else if (name === 'nextTarget') {
      return nextTarget = value;
    }
  };

  exports.calculateNextMove = calculateNextMove;

  exports.formatMessage = formatMessage;

  exports.getPositionOfNextTile = getPositionOfNextTile;

  exports.calculateAngleBetweenVectors = calculateAngleBetweenVectors;

  exports.convertToDegrees = convertToDegrees;

}).call(this);
