﻿#region License

// --------------------------------------------------
// Copyright © OKB. All Rights Reserved.
// 
// This software is proprietary information of OKB.
// USE IS SUBJECT TO LICENSE TERMS.
// --------------------------------------------------

#endregion

using System;
using System.IO;
using System.Net.Sockets;
using System.Text;
using System.Threading;

namespace Tasks
{
    public class Communicator : Logger
    {
        public TcpClient Client = new TcpClient();
        public StreamReader Reader = null;
        public Stream Writer = null;

        public void Close()
        {
            Console.WriteLine("Closing connectiong...");
            this.Client.Close();
        }


        public void Connect(string name, string host = "localhost", int port = 31337)
        {
            Console.Write("Connecting to server: ");
            try
            {
                this.Client.Connect(host, port);

                //Wait for the server to connect
                Thread.Sleep(100);

                if (this.Client.Connected)
                {
                    this.Writer = this.Client.GetStream();
                    this.Reader = new StreamReader(this.Client.GetStream(), Encoding.UTF8);
                    Console.WriteLine("Connected!");

                    SendCommand(name);
                }
            }
            catch (Exception e)
            {
                Console.WriteLine("Unable to connect to " + host + ":" + port);
            }
        }


        public string ReadResponse()
        {
            //Add graceful stop
            try
            {
                return this.Reader.ReadLine();
            }
            catch (Exception e)
            {
                Console.WriteLine("Connection to server lost! Did I win?!");
                Environment.Exit(0);
            }

            return "";
        }


        public void SendCommand(string command, bool verbose = true)
        {
            if (string.IsNullOrEmpty(command))
                return;

            //Send the data
            ASCIIEncoding asen = new ASCIIEncoding();
            byte[] data = asen.GetBytes(command);
            this.Writer.Write(data, 0, data.Length);

            if (verbose)
                Log(LogType.INFO, "Sending string command", command);
        }


        public void SendCommand(int command, bool silent = false)
        {
            SendCommand(command + "\n", silent);
        }
    }


    public static class Command
    {
        public static int Up = 1;
        public static int Down = 2;
        public static int Left = 4;
        public static int Right = 8;
        public static int Drift = 16;
        public static int Use = 32;
    }
}