﻿#region License

// --------------------------------------------------
// Copyright © OKB. All Rights Reserved.
// 
// This software is proprietary information of OKB.
// USE IS SUBJECT TO LICENSE TERMS.
// --------------------------------------------------

#endregion

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;

namespace Tasks.Models
{
    public class Map
    {
        public int CurrentPathNode { get; set; }
        public List<Modifier> Modifiers { get; set; }
        public List<Path> Nodes { get; set; }
        public List<Path> Road { get; set; }
        public List<Path> Open { get; set; }
        public List<Path> Closed { get; set; }

        public List<Path> Path
        {
            get { return Nodes; }
            set
            {
                //Store nodes for later if we need it
                Nodes = value;
                Open = new List<Path>();
                Closed = new List<Path>();
                Road = new List<Path>();
                Path Current = null;
                int min = 9999;

                Current = Nodes.LastOrDefault();
                Current.Distance = 9999;
                Open.Add(Current);

                //Calculate best path
                foreach (Path target in Nodes)
                {
                    //Go trough all open cordinations
                    while (Open.Count != 0)
                    {
                        if (Distance(Current, target) == 0)
                        {
                            ReverseAddToRoad(Current);
                            Open = new List<Path>();
                            Closed = new List<Path>();
                            Open.Add(Current);
                            break;
                        }


                        //Get cordinations for all directions
                        var up = Current.Up();
                        var down = Current.Down();
                        var left = Current.Left();
                        var right = Current.Right();

                        //Add to open if they are roads
                        if (isRoad(up) && Closed.Count(x => x.Tile_X == up.Tile_X && x.Tile_Y == up.Tile_Y) == 0)
                        {
                            up.Distance = Distance(up, target);
                            up.Previous = Current;
                            Open.Add(up);
                        }

                        if (isRoad(down) && Closed.Count(x => x.Tile_X == down.Tile_X && x.Tile_Y == down.Tile_Y) == 0)
                        {
                            down.Distance = Distance(down, target);
                            down.Previous = Current;
                            Open.Add(down);
                        }

                        if (isRoad(left) && Closed.Count(x => x.Tile_X == left.Tile_X && x.Tile_Y == left.Tile_Y) == 0)
                        {
                            left.Distance = Distance(left, target);
                            left.Previous = Current;
                            Open.Add(left);
                        }

                        if (isRoad(right) && Closed.Count(x => x.Tile_X == right.Tile_X && x.Tile_Y == right.Tile_Y) == 0)
                        {
                            right.Distance = Distance(right, target);
                            right.Previous = Current;
                            Open.Add(right);
                        }

                        //Add the current to the closed list
                        Closed.Add(Current);

                        //Remove current from open list
                        var delete = Open.FirstOrDefault(x => x.Tile_X == Current.Tile_X && x.Tile_Y == Current.Tile_Y);
                        Open.Remove(delete);

                        //Set new current
                        if (Open.Count != 0)
                        {
                            min = Open.Min(x => x.Distance);
                            Current = Open.FirstOrDefault(x => x.Distance == min);
                        }
                        
                        if (min == 0 || Open.Count == 0)
                        {
                            //We have reached our target!
                            //Add this path to road
                            ReverseAddToRoad(Current);
                            Open = new List<Path>();
                            Closed = new List<Path>();
                            Open.Add(Current);
                            Current = target;
                            break;
                        }
                    }
                }
            }
        }

        public int Tile_Height { get; set; }
        public int Tile_Width { get; set; }
        public string[][] Tiles { get; set; }


        public int Distance(Path from, Path to)
        {
            return Math.Abs(from.Tile_X - to.Tile_X) + Math.Abs(from.Tile_Y - to.Tile_Y);
        }


        public void ReverseAddToRoad(Path road)
        {
            List<Path> newRoad = new List<Path> { road };
            while (road.Previous != null)
            {
                newRoad.Add(road.Previous);
                road = road.Previous;
            }

            //Reverse the road
            newRoad.Reverse();
            Road.AddRange(newRoad);
        }

        public Coordinate GetPathCoordinate(Path path)
        {
            return new Coordinate
            {
                X = path.Tile_X * Tile_Width,
                Y = path.Tile_Y * Tile_Height
            };
        }


        public bool isRoad(Path path)
        {
            string tile = "";
            try
            {
                tile = this.Tiles[path.Tile_Y][path.Tile_X];
            }
            catch (Exception e)
            {
                return false;
            }
            
            if (tile == "/" || tile == "-" || tile == "|" || tile == "\\" || tile == "`" || tile == "," || tile == "+")
            {   
                return true;
            }

            return false;
        }
    }
}