package artificialstupidity;

import Structures.Car;
import Structures.Node;
import Structures.Shell;
import Structures.VectorF2D;
import java.util.List;
import java.util.Scanner;

public class ArtificialStupidity {
    
    public static void main(String[] args) {
        Scanner input = new Scanner(System.in);
        String host = "localhost";
        String name = "Laksen";
        int port = 31337;
        float speed = 0;
        List<Node> path;
        
        System.out.print("Host: ");
        host = input.next();
        
        System.out.print("Port: ");
        port = input.nextInt();
        
        Networking network = new Networking(host, port, name);
        AStar pathfinder;
        
        pathfinder = new AStar(network.game.game_info.map);
        path = pathfinder.GetFullPath(network.game.game_info.map.node_path, network.game.local_node, network.game.local_car);
        
        ////////////////////////////
        speed = 1000; //just go at max speed, didn't find time to come up with an algorithm.
        while(true) {
            for(Node node : path) {
                float distance = Math.abs(node.GetFX() - network.game.local_car.pos.x) + Math.abs(node.GetFY() - network.game.local_car.pos.y);
                
                while(distance > 1) {
                    Car local_car = network.game.local_car;
                    VectorF2D newDirection = new VectorF2D(node.GetFX() - local_car.pos.x, node.GetFY() - local_car.pos.y).normalized();
                    
                    network.SetDirection(newDirection);
                    network.SetSpeed(speed, newDirection);
                    network.Powerup();
                    
                    distance = Math.abs(node.GetFX() - network.game.local_car.pos.x) + Math.abs(node.GetFY() - network.game.local_car.pos.y);
                }
            }
            
            
        }
    }
}
