from TheKartering import TheKartering
try:
	import pygame
except:
	pass
import math

class HybridKart(TheKartering):
	def loop(self):
		command = 0
		if self.car:
			command |= self.steerTowards(self.nextTile.getCenter())
			if self.car.powerup:
				command |= self.ACTION
		return command
	def steerTowards(self, point):
		#debug
		if self.gui:
			pygame.draw.aalines(self.screen, self.GREEN, False, [(self.car.x, self.car.y), point], 1)
			pygame.draw.circle(self.screen, self.GREEN, point, 3, 0)

		p2p = 180-math.degrees(math.atan2(-(point[1]-self.car.y), -(point[0]-self.car.x)))
		command = self.UP
		try:
			angle = p2p-self.car.dir
			if angle > 180:
				angle = angle-360
			if angle < -180:
				angle = angle+360

			if angle > 75 or angle < -75:
				command = 0

			if angle < 0:
				command |= self.RIGHT
			elif angle > 0:
				command |= self.LEFT
		except Exception, e:
			print "TheKartering.steerTowards:", e

		return command

HybridKart()