﻿using System;
using OpenTK;

namespace Fuseren
{
    public static class Vector2dExtensions
    {
        public static double AngleBetween(this Vector2d a, ref Vector2d b)
        {
            var sin = a.X * b.Y - a.Y * b.X;
            var cos = a.X * b.X + a.Y * b.Y;
            return MathHelper.RadiansToDegrees(Math.Atan2(sin, cos));
        }
    }
}