using System;
using OpenTK;

namespace Fuseren
{
    public struct TilePos : IEquatable<TilePos>
    {
        public static bool operator ==(TilePos left, TilePos right)
        {
            return left.Equals(right);
        }

        public static bool operator !=(TilePos left, TilePos right)
        {
            return !left.Equals(right);
        }

        public bool Equals(TilePos other)
        {
            return X == other.X && Y == other.Y;
        }

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj)) return false;
            return obj is TilePos && Equals((TilePos) obj);
        }

        public override int GetHashCode()
        {
            unchecked
            {
                return (X * 397) ^ Y;
            }
        }

        public int X;
        public int Y;

        public TilePos(int x, int y)
        {
            X = x;
            Y = y;
        }

        public double Distance(TilePos a)
        {
            var x = X - a.X;
            var y = Y - a.Y;
            return (double)Math.Sqrt(x*x + y*y);
        }

        public double ManhattenDistance(TilePos a)
        {
            return Math.Abs(X - a.X) + Math.Abs(Y - a.Y);
        }

        public Vector2d GetAsVector2(int width, int height)
        {
            return new Vector2d(X*width + width*0.5, Y*height + height*0.5);
        }
    }
}