﻿using System.Drawing;
using Interop;
using OpenTK;

namespace Fuseren
{
    public static class ProtocolExtensionMethods
    {
        public static Vector2d Convert(this VectorData vector)
        {
            return new Vector2d(vector.X, vector.Y);
        }

        public static TilePos Convert(this PathData path)
        {
            return new TilePos(path.TileX, path.TileY);
        }

        public static TileType GetTileType(this MapInfo mapInfo, TilePos tilePos)
        {
	        if (tilePos.X < 0 || tilePos.X >= mapInfo.Tiles[0].Count ||
	            tilePos.Y < 0 || tilePos.Y >= mapInfo.Tiles.Count)
		        return TileType.Empty;

            return mapInfo.Tiles[tilePos.Y][tilePos.X];
        }

        public static Size GetSizeInPixels(this MapInfo mapInfo)
        {
            return new Size(mapInfo.Tiles[0].Count * mapInfo.TileWidth, mapInfo.Tiles.Count * mapInfo.TileHeight);
        }

        public static Size GetMapSize(this MapInfo mapInfo)
        {
            return new Size(mapInfo.Tiles[0].Count, mapInfo.Tiles.Count);
        }

	    public static bool IsInvalidPoint(this MapInfo mapInfo, Point p)
	    {
		    var size = mapInfo.GetMapSize();
		    return p.X < 0 || p.Y < 0 || p.X >= size.Width * mapInfo.TileWidth || p.Y >= size.Height * mapInfo.TileHeight;
	    }
    }
}