from coord import Coord


class Players:
    players = {}
    own_id = 0

    def __init__(self, players_list=None, own_id=None):
        pass

    def update(self, player_list, own_id):
        self.own_id = own_id
        for player in player_list:
            if not player['id'] in self.players:
                self.players[player['id']] = self.prepcoords_for_player(player)
            else:
                self.update_player(player)

    def update_player(self, player):
        newinfo = self.prepcoords_for_player(player)
        # Update pos, vel and dir only to keep any other info we have injected during round
        self.players[player['id']]['pos'] = newinfo['pos']
        self.players[player['id']]['velocity'] = newinfo['velocity']
        self.players[player['id']]['direction'] = newinfo['direction']

    def prepcoords_for_player(self, player):
        player['pos'] = self.parse_vector(player['pos'])
        player['velocity'] = self.parse_vector(player['velocity'])
        player['direction'] = self.parse_vector(player['direction'])

        return player

    def parse_vector(self, vector):
        if (vector == None):
            return None

        return Coord(x=vector['x'], y=vector['y'])
