#!/bin/python
import socket
import json
import math
from sys import argv
import re
from astar_path import AStarPathfind


#######################################
#                                     #
#  Written by Fredrik Strupe for the  #
#  TG15 AI Programming competition.   #
#  (04.04.2015)                       #
#                                     #
#######################################


action = {'accelerate': 1<<0,
			'decelerate': 1<<1,
			'left': 1<<2,
			'right': 1<<3,
			'drift': 1<<4,
			'powerup': 1<<5}

class TrackData:
	def __init__(self):
		pass

	def getRawData(self, sock):
		try:
			datablock = sock.recv(4096)
			return datablock
		except:
			print "Quitting"
			quit()

	def getInitData(self, sock):
		data = json.loads(self.getRawData(sock))

		self.id = data['id']
		self.tileWidth = data['map']['tile_width']
		self.tileHeight = data['map']['tile_height']
		self.tileMap = data['map']['tiles'] # 2d array (tileMap[y][x])
		self.modifiers = data['map']['modifiers'] # List of dictionaries
		self.tileCheckpoints = data['map']['path'] # List of dictionaries

	def updateTrackData(self, sock):
		data = json.loads(self.getRawData(sock))

		self.cars = data['cars']
		self.ownCar = self.cars[self.id]
		self.shells = data['shells']
		self.boxes = data['boxes']
		self.items = data['items']

	def generatePath(self):
		drivableTileMap = [[str(self.tileMap[y][x]) for x in xrange(len(self.tileMap[0]))]\
													for y in xrange(len(self.tileMap))]

		path = AStarPathfind(drivableTileMap, self.tileCheckpoints)
		self.tilePath = path

		'''
		for x in xrange(len(path)):
			print str(path[x]['tile_x']) + ', ' + str(path[x]['tile_y'])
			if x % 3 == 0:
				print
		quit()
		'''
		
	def generateWaypoints(self):
		# The waypoints are closely packed together, to resemble a racing line
		self.waypoints = [] # The waypoints should be in pixel coordinates relative to the window
		self.waypointsInPathTile = [] # Example waypointInPathTile[5] = [78, 79, 80 etc.]
		waypointsPerTile = 20
		waypointSpace = self.tileWidth / (waypointsPerTile * 1.0)

		#self.tilePath = self.tilePath[::-1] # Reverse the path (for testing)

		for x in xrange(len(self.tilePath)):
			currTileType = self.tileMap[self.tilePath[x]['tile_y']][self.tilePath[x]['tile_x']]
			step = ((2*math.pi) / 4.0) / (waypointsPerTile * 1.0) 
			radius = self.tileWidth / 2.0
			currWaypoints = []

			nextTilePath = 0
			try:
				nextTilePath = self.tilePath[x+1]
			except:
				nextTilePath = self.tilePath[1]

			if currTileType == '+':
				if nextTilePath['tile_y'] == self.tilePath[x]['tile_y'] == self.tilePath[x-1]['tile_y']:
					currTileType = '-'
				elif nextTilePath['tile_x'] == self.tilePath[x]['tile_x'] == self.tilePath[x-1]['tile_x']:
					currTileType = '|'
				elif (self.tilePath[x-1]['tile_y'] < nextTilePath['tile_y'] and self.tilePath[x]['tile_x'] > self.tilePath[x-1]['tile_x']) or\
					(self.tilePath[x-1]['tile_y'] > nextTilePath['tile_y'] and self.tilePath[x]['tile_x'] > nextTilePath['tile_x']):
					currTileType = '`'
				elif (self.tilePath[x-1]['tile_y'] < nextTilePath['tile_y'] and self.tilePath[x]['tile_x'] < self.tilePath[x-1]['tile_x']) or\
					(self.tilePath[x-1]['tile_y'] > nextTilePath['tile_y'] and self.tilePath[x]['tile_x'] < nextTilePath['tile_x']):
					currTileType = '/'
				elif (self.tilePath[x-1]['tile_y'] < nextTilePath['tile_y'] and self.tilePath[x]['tile_x'] < nextTilePath['tile_x']) or\
					(self.tilePath[x-1]['tile_y'] > nextTilePath['tile_y'] and self.tilePath[x]['tile_x'] < self.tilePath[x-1]['tile_x']):
					currTileType = '\\'
				elif (self.tilePath[x-1]['tile_y'] < nextTilePath['tile_y'] and self.tilePath[x]['tile_x'] > nextTilePath['tile_x']) or\
					(self.tilePath[x-1]['tile_y'] > nextTilePath['tile_y'] and self.tilePath[x]['tile_x'] > self.tilePath[x-1]['tile_x']):
					currTileType = ','

			if currTileType == '-':
				y_center = self.tilePath[x]['tile_y'] * self.tileHeight + self.tileHeight / 2.0
				x_start = self.tilePath[x]['tile_x'] * self.tileWidth
				direction = 1

				# Path going to the the left (instead of to the right)
				if self.tilePath[x]['tile_x'] < self.tilePath[x-1]['tile_x']:
					x_start = (self.tilePath[x]['tile_x'] + 1) * self.tileWidth
					direction = -1

				for i in xrange(waypointsPerTile):
					waypoint = {'x': x_start + direction*i*waypointSpace, 'y': y_center}
					currWaypoints.append(waypoint)

			elif currTileType == '|':
				x_center = self.tilePath[x]['tile_x'] * self.tileWidth + self.tileWidth / 2.0
				y_start = self.tilePath[x]['tile_y'] * self.tileHeight
				direction = 1

				# Path going up (instead of down)
				if self.tilePath[x]['tile_y'] < self.tilePath[x-1]['tile_y']:
					y_start = (self.tilePath[x]['tile_y'] + 1) * self.tileHeight
					direction = -1

				for i in xrange(waypointsPerTile):
					waypoint = {'x': x_center, 'y': y_start + direction*i*waypointSpace}
					currWaypoints.append(waypoint)

			elif currTileType == '`':# or\
				#(currTileType == '+' and self.tilePath[x]['tile_x']):
				x_start = self.tilePath[x]['tile_x'] * self.tileWidth
				y_start = (self.tilePath[x]['tile_y'] + 1) * self.tileHeight

				for i in xrange(waypointsPerTile):
					waypoint = 0
					# Path going right and down
					if self.tilePath[x]['tile_x'] > self.tilePath[x-1]['tile_x']:
						waypoint = {'x': x_start + radius * math.cos((math.pi/2.0) - i*step), 
									'y': y_start + radius * math.sin((math.pi*(3.0/2.0)) + i*step)}
					# Path going up and left
					else:
						waypoint = {'x': x_start + radius * math.cos(i*step), 
									'y': y_start + radius * math.sin(-i*step)}
					currWaypoints.append(waypoint)

			elif currTileType == ',':
				x_start = self.tilePath[x]['tile_x'] * self.tileWidth
				y_start = self.tilePath[x]['tile_y'] * self.tileHeight

				for i in xrange(waypointsPerTile):
					waypoint = 0
					# Path going down and left
					if self.tilePath[x]['tile_y'] > self.tilePath[x-1]['tile_y']:
						waypoint = {'x': x_start + radius * math.cos(i*step),
									'y': y_start + radius * math.sin(i*step)}
					# Path going right and up
					else:
						waypoint = {'x': x_start + radius * math.cos((math.pi/2.0) - i*step),
									'y': y_start + radius * math.sin((math.pi/2.0) - i*step)}	
					currWaypoints.append(waypoint)

			elif currTileType == '\\':# or\
				#(currTileType == '+' and (nextTilePath['tile_x'] - self.tilePath[x]['tile_x'] == )):
				x_start = (self.tilePath[x]['tile_x'] + 1) * self.tileWidth
				y_start = self.tilePath[x]['tile_y'] * self.tileHeight

				for i in xrange(waypointsPerTile):
					waypoint = 0
					# Path going left and up
					if self.tilePath[x]['tile_x'] < self.tilePath[x-1]['tile_x']:
						waypoint = {'x': x_start + radius * math.cos((math.pi*(3.0/2.0)) - i*step),
									'y': y_start + radius * math.sin((math.pi/2.0) - i*step)}
					# Path going down and right
					else:
						waypoint = {'x': x_start + radius * math.cos(math.pi - i*step),
									'y': y_start + radius * math.sin(math.pi - i*step)}
					currWaypoints.append(waypoint)

			elif currTileType == '/':
				x_start = (self.tilePath[x]['tile_x'] + 1) * self.tileWidth
				y_start = (self.tilePath[x]['tile_y'] + 1) * self.tileHeight

				for i in xrange(waypointsPerTile):
					waypoint = 0
					# Path going up and right
					if self.tilePath[x]['tile_y'] < self.tilePath[x-1]['tile_y']:
						waypoint = {'x': x_start + radius * math.cos(math.pi - i*step),
									'y': y_start + radius * math.sin(-i*step)}
					# Path going left and down
					else:
						waypoint = {'x': x_start + radius * math.cos((math.pi*(3.0/2.0)) - i*step),
									'y': y_start + radius * math.sin((math.pi*(3.0/2.0)) - i*step)}
					currWaypoints.append(waypoint)

			self.waypoints += currWaypoints # The two lists are concatenated into one list
			self.waypointsInPathTile.append(currWaypoints) # currWaypoints list is added as an item

def getTargetWaypoint(track, prevWaypoint):
	# arrowLength is proportional to the velocity vector
	arrowLength = math.sqrt(track.ownCar['velocity']['x']**2 + track.ownCar['velocity']['y']**2)
	arrowLength *=  0.9
	currPos = track.ownCar['pos']

	if 0 < prevWaypoint < 50 and arrowLength < 60: # Have a slightly longer arrow at the start of a lap
		arrowLength = 60
	elif arrowLength < 20:
		arrowLength = 20

	carTilePos = {'tile_x': int(track.ownCar['pos']['x'] // track.tileWidth),
					'tile_y': int(track.ownCar['pos']['y'] // track.tileHeight)}
	
	if carTilePos == track.tileCheckpoints[getTargetWaypoint.currCheckpoint]:
		if getTargetWaypoint.currCheckpoint == 0:
			getTargetWaypoint.roundStart = True
		elif getTargetWaypoint.currCheckpoint >= 1 and getTargetWaypoint.roundStart == True:
			getTargetWaypoint.roundStart = False
		getTargetWaypoint.currCheckpoint += 1
		if getTargetWaypoint.currCheckpoint >= len(track.tileCheckpoints):
			getTargetWaypoint.currCheckpoint = 0

	indicesIndex = 0
	indices = [0]
	try:
		indices = [i for i, x in enumerate(track.tilePath) if x == track.tileCheckpoints[getTargetWaypoint.currCheckpoint]]
	except:
		indices = [0]

	if prevWaypoint == -1:
		shortestDistance = 9999
		shortestDistanceWaypoint = 0
		for x in xrange(indices[0]+20):
			x_diff = track.waypoints[x]['x'] - currPos['x']
			y_diff = track.waypoints[x]['y'] - currPos['y']
			distance = math.sqrt(x_diff**2 + y_diff**2)

			if distance < shortestDistance:
				shortestDistance = distance
				shortestDistanceWaypoint = x
		prevWaypoint = shortestDistanceWaypoint

	x = prevWaypoint + 1
	if x >= len(track.waypoints):
		x = 0

	nextWaypoint = prevWaypoint
	arrowLengthCopy = arrowLength
	for i in xrange(20):
		x_diff = track.waypoints[x]['x'] - currPos['x']
		y_diff = track.waypoints[x]['y'] - currPos['y']
		distance = math.sqrt(x_diff**2 + y_diff**2)

		if distance <= arrowLengthCopy:
			nextWaypoint = x
			x += 1
			if x >= len(track.waypoints):
				x = 0
		elif distance > arrowLengthCopy:
			x_diff_waypoints = track.waypoints[x]['x'] - track.waypoints[x-1]['x']
			y_diff_waypoints = track.waypoints[x]['y'] - track.waypoints[x-1]['y']
			distance_waypoints = math.sqrt(x_diff_waypoints**2 + y_diff_waypoints**2)

			if distance_waypoints > arrowLength:
				nextWaypoint = x
				break
			else:
				break

	newLap = False
	while True:
		pathIndex = indices[indicesIndex]+1
		maxWaypoint = 0
		for x in xrange(len(track.waypointsInPathTile[:pathIndex])):
			maxWaypoint += len(track.waypointsInPathTile[x])

		maxWaypoint -= 1 # Last waypoint in immediate next tile, not first waypoint in the tile after that

		if newLap:
			break
		elif maxWaypoint < getTargetWaypoint.prevMaxWaypoint:
			indicesIndex += 1
			if indicesIndex >= len(indices):
				indicesIndex = 0
				newLap = True
		else:
			break

	if nextWaypoint > maxWaypoint and getTargetWaypoint.currCheckpoint != 0:
		nextWaypoint = maxWaypoint
	if nextWaypoint < maxWaypoint and nextWaypoint <= len(track.waypointsInPathTile[0]) and getTargetWaypoint.currCheckpoint != 0 and getTargetWaypoint.roundStart == False:
		nextWaypoint = maxWaypoint

	getTargetWaypoint.prevMaxWaypoint = maxWaypoint

	return nextWaypoint

def moveTowardsWaypoint(track, waypoint):
	actionBitmap = 0

	x_diff = track.waypoints[waypoint]['x'] - (track.ownCar['pos']['x'])
	y_diff = track.waypoints[waypoint]['y'] - (track.ownCar['pos']['y'])
	length = math.sqrt(x_diff**2 + y_diff**2)

	# The car's direction vector should approach this vector
	targetDir = {'x': x_diff / length, 'y': y_diff / length}
	currDir = track.ownCar['direction']

	angle = math.atan2(targetDir['y'], targetDir['x']) - math.atan2(currDir['y'], currDir['x'])
	
	while angle < -math.pi: angle += 2*math.pi
	while angle > math.pi:  angle -= 2*math.pi

	angle = math.degrees(angle)

	if abs(angle) < 90:
		actionBitmap = actionBitmap | action['accelerate']
	else:
		actionBitmap = actionBitmap | action['decelerate']

	# The obstacle avoidance doesn't work properly on non-linear maps (like the default map).
	# It is therefore disabled, as it is better to finish late than never
	# (for maps where the obstacle avoidance makes the car unable to finish)
	#avoidObs = avoidObstacle(track)
	avoidObs = 0
	if avoidObs != 0:
		actionBitmap = actionBitmap | avoidObs
	else:
		if angle > 2.5:
			actionBitmap = actionBitmap | action['right']
		elif angle < -2.5:
			actionBitmap = actionBitmap | action['left']

	return actionBitmap


def avoidObstacle(track):
	mainProbeLen = 150

	mainProbeVec = {'x': track.ownCar['direction']['x'] * mainProbeLen,
					'y': track.ownCar['direction']['y'] * mainProbeLen}

	probeStartPos = {'x': track.ownCar['pos']['x'],
					 'y': track.ownCar['pos']['y']}

	for modifier in track.modifiers + track.items:
		if modifier['type'] != 'ice':
			modifierCenter = {'x': modifier['x'] + (modifier['width'] / 2.0) , 
		 			  		  'y': modifier['y'] + (modifier['height'] / 2.0)}
			
			radius = math.sqrt((modifier['width'] / 2.0)**2 + (modifier['height'] / 2.0)**2)
			radius -= 5.0

			tileCoord = {'x': int(modifierCenter['x'] // track.tileWidth),
						 'y': int(modifierCenter['y'] // track.tileHeight)}
			tileType = track.tileMap[tileCoord['y']][tileCoord['x']]

			carTilePos = {'tile_x': int(track.ownCar['pos']['x'] // track.tileWidth),
							'tile_y': int(track.ownCar['pos']['y'] // track.tileHeight)}
			
			pathIndex = 0
			try: 
				pathIndex = track.tilePath.index(carTilePos)
				track.tilePath[pathIndex+1]
			except: 
				pathIndex = avoidObstacle.prevPathIndex

			avoidObstacle.prevPathIndex = pathIndex

			nextTilePath = 0
			try:
				nextTilePath = track.tilePath[pathIndex+1]
			except:
				nextTilePath = track.tilePath[1]

			'''
			# Hack to make the car go towards boosters
			if modifier['type'] == 'booster':
				radius *= 2
				if tileType == '-':
					diffY_top = modifierCenter['y'] - tileCoord['y'] * track.tileHeight
					diffY_bot = (tileCoord['y'] * track.tileHeight + track.tileHeight) - modifierCenter['y']
					if diffY_top > diffY_bot:
						modifierCenter['y'] -= radius
					else:
						modifierCenter['y'] += radius
				elif tileType == '|':
					diffX_left = modifierCenter['x'] - tileCoord['x'] * track.tileWidth
					diffX_right = (tileCoord['x'] * track.tileWidth + track.tileWidth) - modifierCenter['x']
					if diffX_left > diffX_right:
						modifierCenter['x'] -= radius
					else:
						modifierCenter['x'] += radius
			'''

			if isProbeIntersecting(probeStartPos, mainProbeVec, modifierCenter, radius):
				# Don't do avoidance if the car's center is beyond the center of the modifier
				if tileType == '-' or\
					(tileType == '+' and nextTilePath['tile_y'] == track.tilePath[pathIndex]['tile_y'] == track.tilePath[pathIndex-1]['tile_y']):
					if track.tilePath[pathIndex+1]['tile_x'] < carTilePos['tile_x']:
						if track.ownCar['pos']['x'] < modifierCenter['x'] + modifier['width']/4:
							return 0
					else:
						if track.ownCar['pos']['x'] > modifierCenter['x'] - modifier['width']/4:
							return 0
				elif tileType == '|' or\
					(tileType == '+' and nextTilePath['tile_x'] == track.tilePath[pathIndex]['tile_x'] == track.tilePath[pathIndex-1]['tile_x']):
					if track.tilePath[pathIndex+1]['tile_y'] < carTilePos['tile_y']:
						if track.ownCar['pos']['y'] < modifierCenter['y'] + modifier['width']/4:
							return 0
					else:
						if track.ownCar['pos']['y'] > modifierCenter['y'] - modifier['width']/4:
							return 0

				# Ignore the modifier if probeStartPos is inside it;
				# it will be easier to just go straight through it
				if modifier['x'] < probeStartPos['x'] < modifier['x'] + modifier['width'] and\
					modifier['y'] < probeStartPos['y'] < modifier['y'] + modifier['height']:
					return action['accelerate']

				if tileType == '-' or\
					(tileType == '+' and nextTilePath['tile_y'] == track.tilePath[pathIndex]['tile_y'] == track.tilePath[pathIndex-1]['tile_y']):
					diffY_top = modifierCenter['y'] - tileCoord['y'] * track.tileHeight
					diffY_bot = (tileCoord['y'] * track.tileHeight + track.tileHeight) - modifierCenter['y']

					# Track is going to the left
					if track.ownCar['pos']['x'] > modifierCenter['x']:
						return action['left'] if diffY_bot > diffY_top else action['right']
					# Track is going to the right
					else:
						return action['right'] if diffY_bot > diffY_top else action['left']
				elif tileType == '|' or\
					(tileType == '+' and nextTilePath['tile_x'] == track.tilePath[pathIndex]['tile_x'] == track.tilePath[pathIndex-1]['tile_x']):
					diffX_left = modifierCenter['x'] - tileCoord['x'] * track.tileWidth
					diffX_right = (tileCoord['x'] * track.tileWidth + track.tileWidth) - modifierCenter['x']
					# Track is going upward
					if track.ownCar['pos']['y'] > modifierCenter['y']:
						return action['left'] if diffX_left > diffX_right else action['right'] 
					else:
						return action['right'] if diffX_left > diffX_right else action['left']

	return 0

def isProbeIntersecting(probeStartPos, probeVec, targetPoint, radius):
	def dist2(v, w):
		return ((v['x'] - w['x'])**2 + (v['y'] - w['y'])**2)

	# vw is the probe line segment, and p is the point in the modifier's center
	v = probeStartPos
	w = {'x': v['x'] + probeVec['x'], 'y': v['y'] + probeVec['y']}
	p = targetPoint

	len2 = dist2(v, w)

	# If len2 equals zero, v and w are at the same location
	if len2 == 0:
		return False

	# t is used to project a line segment from p onto a line extending the vw segment
	t = ((p['x']-v['x']) * (w['x']-v['x']) + (p['y']-v['y']) * (w['y']-v['y'])) / len2

	dist = 0 # Distance of the projection squared
	if t < 0:
		dist = dist2(p, v) # The projection will be beyond the v-end of the segment
	elif t > 1:
		dist = dist2(p, w) # Beyond the w-end
	else:
		projection = {'x': v['x'] + t * (w['x'] - v['x']),
					  'y': v['y'] + t * (w['y'] - v['y'])}
		dist = dist2(p, projection)

	dist = math.sqrt(dist)
	return dist < radius

sock = socket.socket()
host = socket.gethostname()

# Will be true if an IP-address is specified as a command line argument
if len(argv) > 1:
	# Check if the specified IP-address is valid.
	if re.match('^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}', argv[1]):
		hostAndPort = argv[1].split(':')
		host = hostAndPort[0]
		if ':' in argv[1]:
			port = int(hostAndPort[1])
	else:
		print 'BAD IP SPECIFIED'
		quit()

port = 31337 # Port always 31337, so ignore specified port 

sock.connect((host, port))
sock.send('bob-kaare\n')

track = TrackData()
track.getInitData(sock)
sock.send(str(action['powerup'])+'\n') # Ready to receive data

track.generatePath()
track.generateWaypoints()

currWaypoint = -1
getTargetWaypoint.currCheckpoint = 0
getTargetWaypoint.prevMaxWaypoint = -1
getTargetWaypoint.roundStart = True

while True:
	track.updateTrackData(sock)

	currWaypoint = getTargetWaypoint(track, currWaypoint)
	actionBitmap = moveTowardsWaypoint(track, currWaypoint)

	actionBitmap = actionBitmap | action['powerup'] # Spray 'n' pray

	sock.send(str(actionBitmap)+'\n')

sock.close()