from astar import AStarGrid, AStarGridNode, GrassNode, HorizontalNode, VerticalNode, LeftDownNode, UpLeftNode, \
    RightUpNode, DownRightNode
from itertools import product

def make_graph(tiles):
    nodes = []
    width = len(tiles[0])
    height = len(tiles)

    for x in xrange(width):
        nodes.append([])
        for y in xrange(height):
            if tiles[y][x] == '|':
                nodes[x].append(VerticalNode(x, y))
            elif tiles[y][x] == '-':
                nodes[x].append(HorizontalNode(x, y))
            elif tiles[y][x] == '`':
                nodes[x].append(LeftDownNode(x, y))
            elif tiles[y][x] == ',':
                nodes[x].append(UpLeftNode(x, y))
            elif tiles[y][x] == '\\':
                nodes[x].append(RightUpNode(x, y))
            elif tiles[y][x] == '/':
                nodes[x].append(DownRightNode(x, y))
            elif not tiles[y][x] == '.':
                nodes[x].append(AStarGridNode(x, y))
            else:
                nodes[x].append(GrassNode(x, y))

    graph = {}
    for x, y in product(range(width), range(height)):
        node = nodes[x][y]
        graph[node] = []
        for i, j in product([-1, 0, 1], [-1, 0, 1]):
            if not (0 <= x + i < width):
                continue
            if not (0 <= y + j < height):
                continue
            graph[node].append(nodes[x + i][y + j])
    return graph, nodes


# Use this
def AStarPathfind(map_tiles, checkpoints):
    completed_path = []
    graph, nodes = make_graph(map_tiles)
    paths = AStarGrid(graph)
    doNotUseSet = set()
    for i in xrange(len(checkpoints)):
        # paths = AStarGrid(graph)
        x = checkpoints[i]['tile_x']
        y = checkpoints[i]['tile_y']
        x_next = checkpoints[(i + 1) % len(checkpoints)]['tile_x']
        y_next = checkpoints[(i + 1) % len(checkpoints)]['tile_y']
        start = nodes[x][y]
        end = nodes[x_next][y_next]
        path = paths.search(start, end, doNotUseSet)
        doNotUseSet = set()
        if path is None:
            print "No path found"
        else:
            del path[-1]
            completed_path += path
            if len(path) > 2:
                doNotUseSet.add(path[-2])

    waypoints = []
    for i in completed_path:
        waypoints.append({'tile_x': i.x, 'tile_y': i.y})

    return waypoints