#include "../core/intersect/intersect.as";
#include "../core/Behaviours/ActorBehaviour.as";
#include "../core/entities/Actor.as";
#include "../core/entities/Particles.as";
#include "../core/input/InputController.as";
#include "../core/interface/Menu.as";
#include "../core/Color.as";
#include "entities/Test.as";
#include "entities/Player.as";
#include "entities/Enemy.as";
#include "Behaviours/EnemyBehaviour01.as";
#include "Effects/Explosion.as";
#include "Effects/Flash.as";
#include "input/InputInterrupt.as";
#include "Wave.as";
#include "bgGen.as";
#include "UItest.as";
#include "Intro.as"

funcdef void CALLBACK(); 
funcdef void CONTROL_REF();

CALLBACK@ interruptRef;



PointLight@ mainTestLight;	
PointLight@ isLight;	
Model@ beamModel;
//BitmapFont@ aldoFont;

Object@ testProp;
Timer@ MAIN_TIMER;
Timer@ INTERRUPT_TIMER;
Timer@ INIT_DELAY_TIMER;
Object@ SKYBOX;
Object@ OBJECT_BULLET_YELLOW;
Object@ OBJECT_EXPLOSION;
Object@ OBJECT_FLASH;
Game@ game;
funcdef void MouseMoveCallback(int x, int y, int xRel, int yRel);
BackgroundGenerator@ bgGen;
BackgroundGenerator@ bgGen2;
Intro@ intro;
void init() {	
	//hideMouse();
	Object@ test1;
	@mainTestLight = PointLight();
	mainTestLight.setPosition(0,0,2);
	mainTestLight.scale(80);
	mainTestLight.color= Color(255,255,255,255);
	s.add(mainTestLight);		


	@OBJECT_BULLET_YELLOW = objectFactory.load(ASSETS_LOCATION+"Models/Effects/bullet.3DS");
	@OBJECT_EXPLOSION = objectFactory.load(ASSETS_LOCATION+"Models/Effects/Explosion2.3DS");
	OBJECT_EXPLOSION.model.getSurface(0).setMaterial(pool.getMaterial(ASSETS_LOCATION+"Materials/explosion.pmat"));	
	@OBJECT_FLASH  = objectFactory.load(ASSETS_LOCATION+"Models/Effects/flash.3DS");
	
	@MAIN_TIMER = control.createTimer(20, true);
	MAIN_TIMER.start();
	@INTERRUPT_TIMER = control.createTimer(20, true);
	INTERRUPT_TIMER.start();	
	
	@SKYBOX = objectFactory.createPoster(ASSETS_LOCATION+"Images/background_01.png");
	SKYBOX.model.getSurface(0).material.mode = pDM_EMISSIVE;
	SKYBOX.scale(0.02);
	SKYBOX_SCENE.add(SKYBOX);
	
	SKYBOX_CAM.translate(0,-10,0);
	
	MAIN_TIMER.elapsed += syncSkybox;
	MAIN_CAM.setPosition(Vector3(0,0,11));
	MAIN_CAM.relRotate(Vector3(-1,0,0), PI*0.5);
	MAIN_CAM.relRotate(Vector3(0,-1,0), PI*0.5);	
	
	
	//@testProp = objectFactory.createCube();
	//testProp.translate(0,5,0);
	//s.add(testProp);
	@game = Game(@s, @MAIN_TIMER, @INTERRUPT_TIMER);
	
	
	
	//createUI();
	//game.init();

	Array<Array<String>> items;
	Array<String> mediumDebris;
	mediumDebris.add("medium_01.3DS");
	mediumDebris.add("medium_02.3DS");
	mediumDebris.add("medium_03.3DS");
	mediumDebris.add("medium_04.3DS");
	items.add(mediumDebris);
	Array<String> smallDebris;
	smallDebris.add("small_01.3DS");
	smallDebris.add("small_02.3DS");
	smallDebris.add("small_03.3DS");
	smallDebris.add("small_04.3DS");
	smallDebris.add("small_05.3DS");
	smallDebris.add("small_06.3DS");
	smallDebris.add("small_07.3DS");
	smallDebris.add("small_08.3DS");
	smallDebris.add("small_09.3DS");
	smallDebris.add("small_10.3DS");
	smallDebris.add("small_11.3DS");
	smallDebris.add("small_12.3DS");
	smallDebris.add("small_13.3DS");
	smallDebris.add("small_14.3DS");
	smallDebris.add("small_15.3DS");
	smallDebris.add("small_16.3DS");
	smallDebris.add("small_17.3DS");
	smallDebris.add("small_18.3DS");
	smallDebris.add("small_19.3DS");
	smallDebris.add("small_20.3DS");
	smallDebris.add("small_21.3DS");
	smallDebris.add("small_22.3DS");
	smallDebris.add("small_23.3DS");
	items.add(smallDebris);	
	Array<uint> ia1 = {2, 20};
	Array<uint> ia2 = {1, 75};
	@bgGen = BackgroundGenerator(@s,@MAIN_TIMER, items, Box(Vector3(-12,-100,-20), Vector3(12,100,-4)), ia1);
	@bgGen2 = BackgroundGenerator(@s,@MAIN_TIMER, items, Box(Vector3(-20,-120,-50), Vector3(20,120,-25)), ia2);	

	@INIT_DELAY_TIMER = control.createTimer(400, false);
	INIT_DELAY_TIMER.elapsed += @initStartup;
	INIT_DELAY_TIMER.start();

}

void initStartup() {
	@intro = Intro(@introEnded);
}
void startGame() {
	game.init();
	bgGen.start();
	bgGen2.start();
		
}

void introEnded()
{
	createUI();
}

void syncSkybox() {
	//SKYBOX_CAM.setRotation(MAIN_CAM.quaternion);
}

class Game {
	Scene@ scene;
	Player@ player;
	InputInterrupt inputInterrupt;
	InputController@ controller;
	InputController@ interruptController;
	Box@ gameStage;
	Timer@ timer;
	Timer@ interruptTimer;
	Array<Enemy@> arrEnemies;
	int genInterval = 1;
	int genDelay = 250;
	uint gameScore = 0;
	uint enemiesKilled = 0;
	uint multiplier = 1;
	Wave@ wave;
	uint lives = 3;
	Game() {
	
	}
	Game(Scene@ s, Timer@ t, Timer@ it) {
		srand(1234);
		@scene = @s;
		@timer = @t;
		@interruptTimer = @it;
		@gameStage = Box(Vector3(-10, -15, -5), Vector3(10, 15, 5));	
		addIntersectGroup(1);
		addIntersectGroup(2);
		addIntersectGroup(3);
		addIntersectGroup(4);
		
		Model@ pete = pool.getModel(ASSETS_LOCATION+"Models/Actors/Player/PT2000.3ds");
		Object@ playerObj = Object();
		@playerObj.model = pete;
		playerObj.model.setColor(Color(255,255,255,255));
		playerObj.scale(Vector3(0.05,0.05,0.05));
		@player = Player(@playerObj, @timer, gameStage);
		@wave = Wave(timer, scene, gameStage);
	}
	
	~Game() {
		// for (uint i = 0; i < arrEnemies.length(); i++) {
			// arrEnemies[i].removeFromScene();
		// }
		//@controller = null;
		//player.removeFromScene();
		//arrEnemies.resize(0);
	}
	void playerDeath() {
		player.setPosition(Vector3(0,-12,0));
		
		multiplier = 1;
		SetMultiplier(multiplier);
		if (lives > 1) {
			lives--;
			RemoveLife();
			player.animate(Vector3(0,-3,0));
		} else {
			RemoveLife();
			Gameover();
			//player.animate(Vector3(0,-3,0));
		}
	}
	void reportScore(uint s) {
		
		if (++enemiesKilled > 10) {
			enemiesKilled = 0;
			multiplier++;
			SetMultiplier(multiplier);
		}
		gameScore += s*multiplier;
		SetScore(gameScore);
	}

	void init() {
		echo("INIT GAME\n");
		player.addToScene(scene);
		player.translate(Vector3(0,0,0));
		SetMultiplier(multiplier);
		//arrEnemies[0].setPosition(Vector3(0,3,0));
		//arrEnemies[0].addToScene(scene);		
		
		@interruptController = InputController(inputInterrupt, @interruptTimer);
		interruptController.repeat = false;
		interruptController.pairs.add(InputControlPair(PK_p, IN_pause));
		interruptController.pairs.add(InputControlPair(PK_o, IN_stopGame));
		interruptController.setActive();
		
		@controller = InputController(@player, @timer);
		
		controller.pairs.add(InputControlPair(PK_d, PA_moveForward));
		controller.pairs.add(InputControlPair(PK_a, PA_moveBackward));
		controller.pairs.add(InputControlPair(PK_w, PA_moveLeft));
		controller.pairs.add(InputControlPair(PK_s, PA_moveRight));
		controller.pairs.add(InputControlPair(PK_SPACE, PA_fireWeapon));
		//controller.setMouseControl(PA_rotateX, PA_rotateY);
		
		controller.setActive();
		timer.elapsed += Action(this.generateEnemy);
	}
	
	void generateEnemy() {
		if (--genInterval < 1) {
			wave.make(Vector3((RandRange(0, 10)-5),12,0), RandRange(1,2));
			// Enemy@ enemy;
			// //@enemy = Enemy(pool.getModel(ASSETS_LOCATION+"Models/Actors/Enemies/test.3ds"), timer, scene, gameStage, EnemyBehaviour02(timer));
			// @enemy = Enemy(pool.getModel(ASSETS_LOCATION+"Models/Actors/Enemies/enemy001.3DS"), timer, scene, gameStage, EnemyBehaviour02(timer));
			// //@enemy = Enemy(pool.getModel(ASSETS_LOCATION+"Models/Actors/Enemies/aim_base.3ds"), timer, scene, gameStage, EnemyBehaviour01(timer));
			// //@enemy = Enemy(pool.getModel(ASSETS_LOCATION+"Models/Actors/Enemies/enemy_spinnig_turret.3DS"), timer, scene, gameStage, EnemyBehaviour01(timer));
			// enemy.rotate(Vector3(0,0,1), PI);
			// enemy.setPosition(Vector3((RandRange(0, 10)-5),12,0));	
			genInterval = genDelay;
			echo(String((RandRange(0, 12)-6))+"\n");
		}	
			
	}
	
	void check() {
		//int x, y;
		//getCursorPos(x, y);
		//echo(String(x)+", "+String(y)+"\n");
	}

}
void makeWave() {
	for (uint i = 0; i < 5;i++) {
		
	}
} 


int RandRange(int min, int max) {
	return min + rand() % (max - min + 1);
}

void killGame() {
	// registry.clear();
	// @game = null;
	// INTERSECT_LIST.clear();
	// s.clear();
	
	MAIN_TIMER.start();
	s.add(MAIN_CAM);
	game.init();
}
void restartGame() {
	registry.clear();
	INTERSECT_LIST.clear();
	@game = null;
	s.clear();
	@game = Game(@s, @MAIN_TIMER, @INTERRUPT_TIMER);

}

int camActive = 0;
void switchCam() {
	switch (camActive) {
		case 0:
			//MAIN_CAM.disable();	
			//MAIN_CAM2.enable();
			
			camActive = 1;
			break;
		case 1:
			//MAIN_CAM.enable();
			//MAIN_CAM2.disable();
			camActive = 0;
			break;			
	}		
}


