// Player.as
//
// Depends on:
// -Actor.as
// -InputControllerFunctions.as

#include "Weapon.as";

class Player:Actor,InputControllerInterface {
	int bankLeftTimer = 0;
	int bankRightTimer = 0;
	int banking = 0;	
	bool moving = false;
	Array<int> camDelay;
	GameObject@ wrapper;
	Object@ camProxy;
	Object@ exhaust1;
	Object@ exhaust2;
	Box@ playerStage;
	Weapon@ weapon;
	Vector3 animDest;
	bool invulnerable = false;
	Timer@ flashTimer;
	Object@ playerModel;
	bool flashingShip = false;
	Player() {
	
	}
	Player(Object@ pModel, Timer@ t, Box@ st) {
		@stage = st;
		@timer = t;
		@wrapper = GameObject();
		@camProxy = Object();
		@exhaust1 = Object();
		@exhaust2 = Object();
		@playerModel = pModel;
		
		@playerStage = Box(Vector3(-6, -10.5, -5), Vector3(6, 10.5, 5));	
		
		wrapper.addChild(playerModel, Vector3(0,0,0));
		wrapper.addChild(exhaust1, Vector3(0.5,-1, 0));
		wrapper.addChild(exhaust2, Vector3(-0.5, -1, 0));
		
		intersectGroup = 4;
		intersectWith = 2;		
		
		this.addChild(wrapper, Vector3(0,0,0));
		this.addChild(camProxy, Vector3(0, -5, 1)); 
		//this.removeChild(wrapper);
		@flashTimer = control.createTimer(100, true);
		
		timer.elapsed += Action(this.check);
		camDelay.resize(IC_FINAL_VAL);
		camDelay[PA_rotateLeft] = 0;
		camDelay[PA_rotateRight] = 0;
		//@weapon = Weapon(timer, stage, 5, 1, 0); 
		@weapon = Weapon(timer, stage, 2, 1, false); 
		weapon.delay = 5;
		addToIntersect(4);
		this.addChild(weapon, Vector3(0, 1, 0));
		flashTimer.start();
	}
	~Player() {
		removeFromScene();
	}
	void addToScene(Scene@ s) {
		GameObject::addToScene(s);
	}
	
	void check() {
		
		if (moving) {
			moving = false;
		} else {
			weapon.delay = 5;
			if (camDelay[PA_rotateLeft] != 0) {
				rotateLeft();
			}
			if (camDelay[PA_rotateRight] != 0) {
				rotateRight();
			}			
		}
		//echo(String(bankLeftTimer)+"\n");
		//intersectTest(this);
		int bankSpeed = 30;
		if (bankLeftTimer > 0) {
			bankLeftTimer -= 10;
			if (banking-bankSpeed > -200) {
				bank(-bankSpeed);
			}
		} else if (bankRightTimer > 0) {
			bankRightTimer -= 10;
			if (banking+bankSpeed < 200) {
				bank(bankSpeed);
			}
		} else if (banking != 0) {
			if (banking < 0) {
				bank(bankSpeed/2);
			} else if (banking > 0) {
				bank(-bankSpeed/2);
			}
		}	
	} 
	void bank(int amount) {
		banking += amount;
		//echo("bank "+String(amount)+"\n");
		//ChildWrapper objWrapper = this.getChildById(0);
		wrapper.relRotate(Vector3(0,1,0), (PI*(float(amount)/1000)));
		
	}		
	void intersectAction(Base@ obj) {
		if (!invulnerable) {
			ExplosionEffect(timer, scene, position);	
			game.playerDeath();
			setInvulnerable(true);
			
		}	
	}
	void stepAnim() {
		if (position.y < animDest.y) {
			this.translate(Vector3(0,0.1,0));
			exhaustEffect();
		} else {
			timer.elapsed -= Action(this.stepAnim);
			setInvulnerable(false);
		}
	}
	void setInvulnerable(bool state) {
		
		invulnerable = state;
		if (state) {
			//flashTimer.start();
			
			flashTimer.elapsed += Action(this.flash);
		} else {
			flashTimer.elapsed -= Action(this.flash);
			playerModel.model.getSurface(0).material.mode = pDM_NORMAL;
			//flashTimer.stop();
		}
	}
	void flash() {
		if (flashingShip) {
			flashingShip = false;
			playerModel.model.getSurface(0).material.mode = pDM_NORMAL;
		} else {
			flashingShip = true;
			playerModel.model.getSurface(0).material.mode = pDM_EMISSIVE;
		}
	}
	void animate(Vector3 dest) {
		animDest = dest;
		//Quaternion q;
		//q.lookAt(Vector3(0,0,1),dest);
		//rotate(q);
		timer.elapsed += Action(this.stepAnim);
	}
	void exhaustEffect() {
		Object@ pObj1 = objectFactory.createSphere();
		pObj1.model.setColor(Color(20,20,200, 255));
		pObj1.model.getSurface(0).material.mode = pDM_ADDITIVE;
		Object@ pObj2 = objectFactory.createSphere();
		pObj2.model.setColor(Color(20,20,200, 255));
		pObj2.model.getSurface(0).material.mode = pDM_ADDITIVE;		
		
		Particle t1(pObj1, timer, ParticleBehaviours().trail(), exhaust1.position, 0.12, scene);
		Particle t2(pObj2, timer, ParticleBehaviours().trail(), exhaust2.position, 0.12, scene);	
	}
	
	void doAction(InputControllerAction action, int val) {
		//echo(" "+String(camProxy.position.x)+", "+String(camProxy.position.y)+", "+String(camProxy.position.z)+"\n");
		switch (action) {
			case PA_fireWeapon:
				{
					weapon.doAction();
				}
				break;
			case PA_moveForward:
				{	
					 exhaustEffect();
					
					Vector3 newPos = this.position+this.quaternion.rotVector3(Vector3(0,0.1,0));
					
					if (playerStage.containsPoint(newPos)) { 
						
						relTranslate(Vector3(0,0.1,0)); 
						weapon.delay = 8;
						moving = true;
					} 
				}
				break;
			case PA_moveBackward:
				{
					Vector3 newPos = this.position+this.quaternion.rotVector3(Vector3(0,-0.1,0));
					if (playerStage.containsPoint(newPos)) { 
						this.relTranslate(Vector3(0,-0.1,0)); 
						weapon.delay = 3;
						moving = true;
					} 
				}				
				break;
			case PA_moveLeft:
				{
					bankLeftTimer = 50;
					Vector3 newPos = this.position+this.quaternion.rotVector3(Vector3(-0.1,0,0));
					if (playerStage.containsPoint(newPos)) { 
						this.relTranslate(Vector3(-0.1,0,0)); 
					}
				}				
				break;
			case PA_moveRight:
				{
					bankRightTimer = 50;
					Vector3 newPos = this.position+this.quaternion.rotVector3(Vector3(0.1,0,0));
					if (playerStage.containsPoint(newPos)) { 
						this.relTranslate(Vector3(0.1,0,0)); 
					}
				}
				break;
			case PA_rotateLeft:
				{
					//bankRightTimer = 50;
					moving = true;
					rotateLeft();			
				}
				break;
			case PA_rotateRight:
				{
					//bankLeftTimer = 50;
					moving = true;
					rotateRight();
				}
				break;	
			case PA_rotateX:
				{
					float compVal = val*0.003;
					echo(String(compVal)+", ");
					this.relRotate(Vector3(0,0,-1), PI*compVal);			
					//this.relTranslate(Vector3(val, 0,0));
				}
				break;
			case PA_rotateY:
				{
					float compVal = val*0.003;
					this.relRotate(Vector3(1,0,0), PI*compVal);
					echo(String(val)+"\n");
				}
				break;				
		}
	}
	
	void rotateLeft() {
		if (moving) {
			this.relRotate(Vector3(0,0,1), PI*0.03);
			if (camDelay[PA_rotateLeft] < 3) {
				camDelay[PA_rotateLeft]++;	
				wrapper.relRotate(Vector3(0,0,-1), PI*0.03);
			} 
		} else {
			camDelay[PA_rotateLeft]--;
			wrapper.relRotate(Vector3(0,0,1), PI*0.03);
		}
	}
	
	void rotateRight() {
		if (moving) {
			this.relRotate(Vector3(0,0,-1), PI*0.03);
			if (camDelay[PA_rotateRight] < 3) {
				camDelay[PA_rotateRight]++;	
				wrapper.relRotate(Vector3(0,0,1), PI*0.03);
			}	
		} else {
			camDelay[PA_rotateRight]--;
			wrapper.relRotate(Vector3(0,0,-1), PI*0.03);
		}
	}
}