#include "../Behaviours/EnemyBehaviour02.as";
Array<Enemy@> arrEnemyReg;
class Enemy:Actor {
	Weapon@ weapon; 
	Enemy() {
	}
	Enemy(Model@ eModel, Timer@ t, Scene@ s, Box@ st, ActorBehaviour@ ab) {
		Object@ object = Object();
		@scene = @s;
		@timer = @t;
		@actorBehaviour = @ab;
		@stage = st;
		intersectGroup = 1;
		intersectWith = 4;
		@object.model = eModel;
		object.scale(Vector3(0.05,0.05,0.05));
		this.addChild(object, Vector3(0,0,0));
		addToScene(scene);		
		addToIntersect(1);
		@ab.actor = this;
		@weapon = Weapon(timer, stage, 3, 4, true);
		this.addChild(weapon, Vector3(0,0,0));
	}
	
	~Enemy() {
		if (addedToScene) {
			Actor::removeFromScene();
		}
	}
	
	void intersectAction(Base@ obj) {
		actorBehaviour.intersectAction(obj);
	}
}


