#include "../core/UI/UI.as";
//int button;
UI@ GameUI;
BitmapFont@ aldoFont;
UIMenu startMenu;
UIMenu gameMenu;
UIMenu creditMenu;
UIMenu inGameMenu;
UIMenu gameoverMenu;

UIContainer@ containerStart;
UIContainer@ containerGame;
UIContainer@ containerCredits;
UIContainer@ healthContainer;
UIContainer@ ingameContainer;
UIContainer@ gameoverContainer;

UITextfield@ scoreNum;
UITextfield@ endScoreNum;
UITextfield@ multiplierNum;

UIImage@ health1;
UIImage@ health2;
UIImage@ health3;

int LifeTick = 0;
void createUI(){
	@aldoFont = pool.getBitmapFont("../../Assets/Fonts/AldoTheApache.fnt");
	@GameUI = UI(@v1, @INTERRUPT_TIMER,3,Vector3(0.5f,0.5f,0.5f));
	//button = 20;
	//UIButton button = UIButton(20,20,"blah");
	// start menu //////////////////////////////////
	UIImage@ iLogo = UIImage("../../Assets/images/asterion_logo_02.png");
	UIButton@ bStart= UIButton("","START");
	//UIButton@ bOptions = UIButton("","OPTIONS");
	UIButton@ bCredits = UIButton("","CREDITS");

	@containerStart =  UIContainer();
	UIContainer@ containerStartMenu =  UIContainer();
	containerStart.AppendChild(iLogo);
	containerStartMenu.AppendChild(bStart);
	//containerStartMenu.AppendChild(bOptions);
	containerStartMenu.AppendChild(bCredits);
	containerStart.AppendChild(containerStartMenu);
	GameUI.Add(containerStart);

	iLogo.Position(Vector3(0,0,150));
	iLogo.Scale(Vector3(1,1,1));
	containerStartMenu.Position(Vector3(-100,0,-100));
	bStart.Position(Vector3(0,0,0));
	//bOptions.Position(Vector3(0,0,-40));
	bCredits.Position(Vector3(0,0,-40));

	@bStart.OnClick = @StartClick;
	@bCredits.OnClick = @ShowCredits;

	startMenu = UIMenu(vert,0);
	startMenu.Enable();
	GameUI.Register(startMenu);

	startMenu.AddMenuItem(@bStart);
	//startMenu.AddMenuItem(@bOptions);
	startMenu.AddMenuItem(@bCredits);

	//////////////////////////////////////////////

	// game UI ///////////////////////////////////

	//score
	@containerGame = UIContainer();
	UITextfield@ score = UITextfield("SCORE:");
	@scoreNum = UITextfield("0");
	UIContainer@ scoreContainer = UIContainer();
	scoreContainer.AppendChild(score);
	scoreContainer.AppendChild(scoreNum);
	containerGame.AppendChild(scoreContainer);
	
	score.Scale(Vector3(0.4f,0.4f,0.4f));
	scoreNum.Scale(Vector3(0.4f,0.4f,0.4f));

	scoreNum.Position(Vector3(80,0,0));
	scoreContainer.Position(Vector3(-500,0,230));

	//multiplier
	UITextfield@ multiplier = UITextfield("MULTIPLIER:");
	@multiplierNum = UITextfield("X0");
	UIContainer@ multiplierContainer = UIContainer();
	multiplierContainer.AppendChild(multiplier);
	multiplierContainer.AppendChild(multiplierNum);
	containerGame.AppendChild(multiplierContainer);

	multiplier.Scale(Vector3(0.4f,0.4f,0.4f));
	multiplierNum.Scale(Vector3(0.4f,0.4f,0.4f));
	
	multiplierNum.Position(Vector3(135,0,0));
	multiplierContainer.Position(Vector3(-500,0,200));
	//GameUI.Add(containerGame);

	//health
	@healthContainer = UIContainer();
	@health1 = UIImage("../../Assets/Images/ui/gameplayUI/health_1.png");
	@health2 = UIImage("../../Assets/Images/ui/gameplayUI/health_2.png");
	@health3 = UIImage("../../Assets/Images/ui/gameplayUI/health_3.png");
	healthContainer.AppendChild(health1);
	healthContainer.AppendChild(health2);
	healthContainer.AppendChild(health3);
	containerGame.AppendChild(healthContainer);

	health1.Scale(Vector3(0.4f,0.4f,0.4f));
	health2.Scale(Vector3(0.4f,0.4f,0.4f));
	health3.Scale(Vector3(0.4f,0.4f,0.4f));

	health2.Position(Vector3(40,0,0));
	health3.Position(Vector3(80,0,0));
	healthContainer.Position(Vector3(405,0,240));
	GameUI.Add(containerGame);
	gameMenu = UIMenu(vert);
	GameUI.Register(gameMenu);
	@gameMenu.EscFunc = @Pause;
	ToggleMenu(false, containerGame, gameMenu);

	//InGame
	
	@ingameContainer = UIContainer();
	UITextfield@ pauseText = UITextfield("-PAUSE-");
	UIButton@ bContinue= UIButton("","CONTINUE");
	//UIButton@ bRestart= UIButton("","RESTART");
	UIButton@ bQuit= UIButton("","QUIT");
	ingameContainer.AppendChild(pauseText);
	ingameContainer.AppendChild(bContinue);
	//ingameContainer.AppendChild(bRestart);
	ingameContainer.AppendChild(bQuit);
	GameUI.Add(ingameContainer);
	pauseText.Scale(Vector3(0.8f,0.8f,0.8f));
	pauseText.Position(Vector3(0,0,60));
	bContinue.Position(Vector3(0,0,0));
	//bRestart.Position(Vector3(0,0,-40));
	bQuit.Position(Vector3(0,0,-40));
	ingameContainer.Position(Vector3(-100,0,-50));
	inGameMenu = UIMenu(vert, 0);
	GameUI.Register(inGameMenu);
	inGameMenu.AddMenuItem(bContinue);
	//inGameMenu.AddMenuItem(bRestart);
	inGameMenu.AddMenuItem(bQuit);
	ToggleMenu(false, ingameContainer, inGameMenu);
	@bContinue.OnClick = @Continue;
	//@bRestart.OnClick = @Restart;
	@bQuit.OnClick = @RestartMainMenu;
	@inGameMenu.EscFunc = @Pause;
	//ToggleMenu(false, containerCredits, creditMenu);
	//////////////////////////////////////////////

	// Credits UI ////////////////////////////////

	@containerCredits = UIContainer();
	UIImage@ creditsText = UIImage("../../Assets/Images/ui/credits_text.png");
	containerCredits.AppendChild(creditsText);
	GameUI.Add(containerCredits);

	creditMenu = UIMenu(none,-1);
	@creditMenu.EscFunc = @CloseCredits;
	GameUI.Register(creditMenu);

	ToggleMenu(false, containerCredits, creditMenu);
	//////////////////////////////////////////////
	// Gameover //////////////////////////////////

	@gameoverContainer = UIContainer();
	UITextfield@ gameoverText = UITextfield("-GAME OVER-");
	UITextfield@ pressSpace = UITextfield("PRESS SPACE TO QUIT");
	UITextfield@ endScore = UITextfield("SCORE:");
	@endScoreNum = UITextfield("120000");
	gameoverContainer.AppendChild(gameoverText);
	gameoverContainer.AppendChild(pressSpace);
	gameoverContainer.AppendChild(endScore);
	gameoverContainer.AppendChild(endScoreNum);

	gameoverText.Scale(Vector3(0.6f,0.6f,0.6f));
	endScoreNum.Scale(Vector3(0.6f,0.6f,0.6f));
	endScore.Scale(Vector3(0.6f,0.6f,0.6f));
	gameoverContainer.Position(Vector3(-170,0,-50));
	gameoverText.Position(Vector3(40,0,50));
	pressSpace.Position(Vector3(-20,0,0));
	endScore.Position(Vector3(40,0,-90));
	endScoreNum.Position(Vector3(155,0,-90));

	GameUI.Add(gameoverContainer);

	gameoverMenu = UIMenu(none,-1);
	@gameoverMenu.SpaceFunc = @RestartMainMenu;
	GameUI.Register(gameoverMenu);
	ToggleMenu(false, gameoverContainer, gameoverMenu);

	//////////////////////////////////////////////
}

void StartClick(){
	ToggleMenu(true, containerGame, gameMenu);
	ToggleMenu(false, containerStart, startMenu);
	startGame();
}

void ToggleMenu(bool state, UIContainer@ container, UIMenu@ menu){

	if(state){
		menu.Enable();
		container.Show();
	} else{
		menu.Disable();
		container.Hide();
	}

}

// remove life counter from UI
void RemoveLife(){

	switch(LifeTick){

		case 0:
			health1.Hide();
		break;

		case 1:
			health2.Hide();
		break;

		case 2:
			health3.Hide();
		break;

		default:
		echo("you're dead jim...:(");
	}
	LifeTick++;

}

void resetLife(){
	LifeTick = 0;
	health1.Show();
	health2.Show();
	health3.Show();
}

void ShowCredits(){
	ToggleMenu(false, containerStart, startMenu);
	ToggleMenu(true, containerCredits, creditMenu);
}

void CloseCredits(){
	ToggleMenu(true, containerStart, startMenu);
	ToggleMenu(false, containerCredits, creditMenu);
}

void Pause(){
	ToggleMenu(true, ingameContainer, inGameMenu);
	ToggleMenu(false, containerGame, gameMenu);
	MAIN_TIMER.pause();
	//Stop Game Timer
}

void Continue(){
	ToggleMenu(true, containerGame, gameMenu);
	ToggleMenu(false, ingameContainer, inGameMenu);
	MAIN_TIMER.start();
	//StartGameTimer
}

void Restart(){
	ToggleMenu(true, containerGame, gameMenu);
	ToggleMenu(false, ingameContainer, inGameMenu);
	
	SetScore(0);
	SetMultiplier(0);
	resetLife();
	restartGame();

}

void Gameover(){
	ToggleMenu(true, gameoverContainer, gameoverMenu);
}

void RestartMainMenu(){
	// ToggleMenu(true, containerStart, startMenu);
	// ToggleMenu(false, ingameContainer, inGameMenu);

	// SetScore(0);
	// SetMultiplier(0);
	// resetLife();
	control.quit();
}

void SetScore(uint score){

	scoreNum.Text(String(score));
	endScoreNum.Text(String(score));

}

void SetMultiplier(uint mult){

	multiplierNum.Text("X"+String(mult));

}

