
funcdef void IntroEndCallback();


class Intro
{
	Intro(IntroEndCallback@ introEndCallback) 
	{
		@callback = introEndCallback;
		@ship = objectFactory.load(ASSETS_LOCATION+"Models/Actors/Player/PT2000.3ds");
		@camera = Camera(90, pFloat(MAIN_WINDOW.width)/MAIN_WINDOW.height, 0.1f, 1000.0f);
		@scene = Scene(OctreePartition());
		
		scene.add(ship);
		scene.add(camera);
		DirectionalLight@ light = DirectionalLight();
		light.rotate(0,0,1,-PI*0.25);
		light.rotate(0,1,0,PI*0.25);
		
		@lead = Object();
		
		scene.add(light);
		
		camera.translate(0,-200,0);
		lead.translate(700, 0, 0);
		ship.lookAt(lead);
		
		ship.translate(-500, 00, 00); 
		@timer = control.createTimer(20, true);
		timer.elapsed += Action(this.moveShip);
		timer.start();
		v1.addCamera(10,camera);
	}
	
	void moveShip()
	{
		ship.relTranslate(0,4,0);		
		lead.translate(0, -5.5, 0);
		ship.lookAt(lead);
		ship.relRotate(0,1,0, PI* 0.4);
		framecount++;
		
		if (framecount == 133)
		{
			callback();
		}
		
		if (framecount == 180)
		{
			//clean up...
			timer.stop();
			@ship = null;
			@lead = null;
			
			scene.clear();
			@scene = null;
			@callback = null;
			v1.removeCamera(camera);
		}
	}
	
	Timer@ timer;
	Scene@ scene;
	Camera@ camera;
	Object@ lead;
	Object@ ship;
	int framecount; 
	IntroEndCallback@ callback;
}



