// linkedLists.as
// --------------
// because Arrays aren't implemented yet I had to make do,
// result of some improvisation below
//

class BaseNode {
	int key;
	Base@ val;
	BaseNode @next = null;
	BaseNode @prev = null;
}

class BaseObjectList {
	BaseNode startNode;
	BaseNode endNode;
	BaseNode@ iter;
	int length = 0;
	BaseObjectList() {
		startNode.key = -1;
		@startNode.next = endNode;
		endNode.key = -1;
		@endNode.prev = startNode;
		@iter = startNode;
	}
	bool checkNext() {
		if (iter.next.key == -1) {
			@iter = startNode;
			return false;
		}
		return true;
	}
	int iterate() {
		@iter = iter.next;
		return iter.key;
	}
	void resetIter() {
		@iter = startNode;
	}
	void clear() {
		@startNode.next = endNode;
		@endNode.prev = startNode;
		@iter = startNode;		
		length = 0;
	}
	BaseNode@ search(int key) {
		BaseNode@ node; 
		if (key > length/2) {
			@node = endNode.prev; 
			while (node !is startNode) {
				if (node.key == key) {
					return node;
				} else if (node.prev.key < key) {
					return node.prev;
				}
				@node = node.prev;
			}
		} else {
			@node = startNode.next; 
			while (node !is endNode) {
				if (node.key == key || node.next.key > key) {
					return node;
				} 
				@node = node.next;
			}			
		}
		return node;
	}
	void insert(int key, Base@ val) {
		BaseNode newNode; 
		if (key < startNode.next.key || startNode.next.key == -1) {
			newNode.key = key;
			@newNode.val = @val;
			@newNode.next = @startNode.next;
			@startNode.next.prev = @newNode;
			@newNode.prev = @startNode;
			@startNode.next = @newNode;
			length++;
		} else if (key > endNode.prev.key) {
			newNode.key = key;
			@newNode.val = @val;
			@newNode.prev = @endNode.prev;
			@endNode.prev.next = @newNode;
			@newNode.next = @endNode;
			@endNode.prev = @newNode;
			length++;
		} else {
			BaseNode@ node;
			@node = search(key);
			if (node.key != key) {
				@newNode.next = node.next;
				@node.next = newNode;
				newNode.key = key;
				@newNode.val = @val;
				@newNode.prev = node;
				length++;
			} else {
				@node.val = val;
			}
		}
	}
	void remove(int key) {
		BaseNode@ node = search(key);
		//echo("REMOVE "+String(node.val.type)+"\n");
		if (node.key != -1) {
			@node.prev.next = @node.next;
			@node.next.prev = @node.prev;
			@node.val = null;
			@node = null;
			length--;
		} else {
			echo("CANT REMOVE KEY: "+String(key)+"\n");
		}
		//echo("remove "+String(length)+"\n");
	}
	int append(Base@ val) {
		
		BaseNode newNode;
		newNode.key = endNode.prev.key+1;
		
		@newNode.val = @val;
		@newNode.prev = endNode.prev;
		@endNode.prev.next = newNode;
		@newNode.next = endNode;
		@endNode.prev = newNode;
		length++;
		return newNode.key;
		//echo("append "+String(length)+"\n");
	}
	Base@ get(int key) {
		BaseNode@ node = search(key);
		if (node.key != -1) {
			return @node.val;
		}
		echo("returning null");
		return null;
	}	
} 


// -------------------------------------------------------
// tree structs
// as of yet unfinished
// ------------------------------------------------------V


// class QTreeNode {
	// Rect@ key;
	// QTreeNode @lt = null;
	// QTreeNode @rt = null;
	// QTreeNode @lb = null;
	// QTreeNode @rb = null;
	// bool hasChildren() {
		// if (lt !is null) {
			// return true;
		// }
		// return false;
	// }	
// }
// class QuadTree {
	// QTreeNode root;
	// QuadTree() {
		// //empty constructor
	// }
	// QuadTree(Rect@ r) {
		// @root.key = r;
	// }
	// QTreeNode@ search(Rect r) {
		// QTreeNode@ node = root;
		// //@node = root;
		// while (node.hasChildren()) {
			// if (node.lt.key.intersects(r)) {
				// @node = node.lt;
			// } else if (node.rt.key.intersects(r)) {
				// @node = node.rt;
			// } else if (node.rb.key.intersects(r)) {
				// @node = node.rb;
			// } else if (node.lb.key.intersects(r)) {
				// @node = node.lb;
			// }
		// }
		// return node;
	// }
	// void subDivide(QTreeNode@ node) {
		// QTreeNode nLt;
		// QTreeNode nRt;
		// QTreeNode nLb;
		// QTreeNode nRb;
		// @node.lt = nLt;
		// @node.rt = nRt;
		// @node.lb = nLb;
		// @node.rb = nRb;
		// float xd = ((node.key.b.x - node.key.a.x)/2)+node.key.a.x;
		// float yd = ((node.key.b.y - node.key.a.y)/2)+node.key.a.y;
		
		// @nLt.key = Rect(Point(node.key.a.x, node.key.a.y), Point(xd, yd));
		// @nRt.key = Rect(Point(xd, node.key.a.y), Point(node.key.b.x, yd));
		// @nLb.key = Rect(Point(node.key.a.x, yd), Point(xd, node.key.b.y));
		// @nRb.key = Rect(Point(xd, yd), Point(node.key.b.x, node.key.b.y));
	// }
	
// }


// Derelict containspoint function (might be useful sometime?)
//	bool containsPoint(Point@ c) {
//		if (c.x >= a.x && c.x <= b.x && c.y >= a.y && c.y <= b.y) {
//			return true;
//		}
//		return false;
//	}

