// 	Controller.as
//

#include "InputControllerAction.as";
#include "InputControllerFunctions.as";

interface InputControllerInterface { 
	void doAction(InputControllerAction, int val = 0); 
}

class InputControlPair {
	pKeyCode key;
	InputControllerAction val;	
	InputControlPair() {
		
	}
	InputControlPair(pKeyCode k, InputControllerAction v) {
		key = k;
		val = v;
	}
}

class InputController {
	Array<InputControlPair@> pairs;
	Array<InputControllerAction> mouseActions;
	Timer@ timer;
	InputControllerInterface @target;
	Menu@ menu;
	private bool mouseControlSet = false;
	bool repeat = true;
	bool evalNext = true;
	Array<pKeyCode>@ prevPressed;
	int type = 0;
	int cursorX;
	int cursorY;
	
	InputController() {	
		//default constructor
	}
	
	InputController(InputControllerInterface @a, Timer@ t) {
		@target = @a;
		@timer = @t;
		
	}
	
	~InputController() {
		echo("controller removed! \n");
	}
	
	void eval() {
		//getCursorPos(cursorX, cursorY)
		Array<pKeyCode> pp;
		for (uint i = 0; i < pairs.length(); i++) {
			if (control.Input.keyIsPressed(pairs[i].key)) {
				
				pp.add(pairs[i].key);
				bool p = false;
				if (!repeat) {
					for (uint i2=0;i2<prevPressed.length(); i2++) {
						if (pairs[i].key == prevPressed[i2]) {
							p = true;
							break;
						}
					}
				}
				if (!p) {
					target.doAction(pairs[i].val);
				}				
			}
		}
		@prevPressed = @pp;
	}
	
	void setMouseControl(InputControllerAction xAction, InputControllerAction yAction) {
		if (mouseControlSet) {
			mouseActions.resize(0);
		} 
		mouseControlSet = true;
		mouseActions.add(xAction);
		mouseActions.add(yAction);
		
	}
	
	void evalMouseMove(int x, int y, int xRel, int yRel) {
		if (evalNext) {
			target.doAction(mouseActions[0], xRel);
			target.doAction(mouseActions[1], yRel);
			MAIN_WINDOW.setCursorPos(int(MAIN_WINDOW.width/2), int(MAIN_WINDOW.height/2));
			evalNext = false;
		} else {
			evalNext = true;
		}
	}	
	
	void setActive() {
		echo("setActive\n");
		if (mouseControlSet) {
			control.Input.mouseMove() += MouseMoveCallback(this.evalMouseMove);	
		}
		timer.elapsed += Action(this.eval);				
	}
	
	void pause() {
		if (mouseControlSet) {
			control.Input.mouseMove() -= MouseMoveCallback(this.evalMouseMove);	
		}
		timer.elapsed -= Action(this.eval);	
	}
	
	void remove() {
		echo("remove controller\n");
		@timer = null;
		@target = null;
		@menu = null;
		
	}
}