enum MenuDir{
	hor,
	vert,
	none
}
class UIMenu{

	int startSelected = 0;
	int selected = -1;
	bool active = false;
	int m_dir = none;
	Array<UIButton@> _menuItems;
	UI_MENU_ESC @EscFunc;
	UI_MENU_ESC @SpaceFunc;

	UIMenu() {

	}

	UIMenu(MenuDir dir, int ss = -1){
		m_dir = dir;
		startSelected = ss;
	}

	void Enable(){
		selected = startSelected;
		active = true;
		SetButtonStates();
		/*for(int i = 0; i<int(_menuItems.length()); i++){
			_menuItems[i].State(BS_Passive);
		}*/
	}

	void Disable(){
		active = false;
		for(int i = 0; i<int(_menuItems.length()); i++){
			_menuItems[i].State(BS_Disabled);
		}
	}

	void AddMenuItem(UIButton@ item){

		_menuItems.add(@item);
		SetButtonStates();
	}

	void next(){
		selected++;
		if(selected == int(_menuItems.length()) ){
			selected = 0;
		}
		SetButtonStates();
	}

	void prev(){
		selected--;
		if(selected < 0){
			selected = int(_menuItems.length() )-1;
		}
		SetButtonStates();
	}

	void MenuAction(InputControllerAction action){
		if(active){
			switch(action){

				case UI_up:
				echo("\nup");
					if(m_dir == vert){
						prev();
					}
				break;

				case UI_down:
					if(m_dir == vert){
						next();
					}
				echo("\ndown");
				break;

				case UI_left:
					if(m_dir == hor){
						prev();
					}
				echo("\nleft");
				break;

				case UI_right:
					if(m_dir == hor){
						next();
					}
				echo("\nright");
				break;

				case UI_enter:
				echo("\nenter");
				break;

				case UI_space:
				echo("\nspace");
				if(selected >-1)
				{
					_menuItems[selected].OnClick();
				}
				if(@SpaceFunc != null )SpaceFunc();
				break;

				case UI_esc:
				echo("\nesc");
				if(@EscFunc != null )EscFunc();
				break;

				default:

			}
		}
	}

	void SetButtonStates(){

		for(int i = 0; i<int(_menuItems.length()); i++){
			if(selected == i){
				_menuItems[i].State(BS_Active);
			} else {
				_menuItems[i].State(BS_Passive);
			}
			
		}
	}
}