uniform float iGlobalTime;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;

void main(void)
{
	vec2 uv = (gl_FragCoord.xy / iResolution.xy);
    vec2 texuv = (uv-vec2(0.5));
    texuv.x *= iResolution.z;


    vec2 uv2 = texuv + vec2(0.5);

    mat2 rotmat;
    float ang = 3.14159 * 0.5 - iGlobalTime * 0.523;
    vec3 cam = vec3(0.0);
    cam.x = sin(iGlobalTime * 0.63) * 3.0;
    cam.y = 2.0+sin(iGlobalTime * 0.763) * 1.6;
    cam.z = iGlobalTime * 3.0;
    float scx = cam.y / (1.0-uv.y);
    rotmat[0].x = sin(ang);
    rotmat[0].y = cos(ang) ;
    rotmat[1].x = -cos(ang);
    rotmat[1].y = sin(ang) ;
    vec2 newuv = texuv * rotmat * scx + cam.xz;

    vec4 effcol = texture2D(iChannel0, newuv) * pow(max(0.0, 1.0 - uv.y), 0.4) * vec4(0.4, 0.1, 0.9, 0.0);
    vec4 logocol = texture2D(iChannel1, uv2);
    vec4 outcol = mix(effcol, logocol * 2.0, logocol.a);
	gl_FragColor = outcol;
}