#version 330

uniform mat4 u_projectionMatrix;
uniform mat4 u_cameraMatrix;

in vec4 a_vertexPos;

out vec3 v_eyeDirection;

void main() {
    mat4 r = u_cameraMatrix;
    r[3][0] = 0.0;
    r[3][1] = 0.0;
    r[3][2] = 0.0;

    vec4 v = r * u_projectionMatrix * a_vertexPos;

    v_eyeDirection = v.xyz;

    gl_Position = a_vertexPos;
}
