var sceneVariables = {};

function processVariables(scene)
{
	if (scene.hasOwnProperty("variables"))
	{
		sceneVariables[scene.name] = scene.variables;

		for (var variableName in scene.variables)
		{
			var variable = scene.variables[variableName];
			addTwVariable(scene.name, variableName, variable.type, variable.definition);
		}
	}
}

for (var programI = 0; demoScript.shaderPrograms !== undefined && programI < demoScript.shaderPrograms.length; programI++)
{
	var shaderProgram = demoScript.shaderPrograms[programI];
	if (shaderProgram.skip === true)
	{
		continue;
	}

	addShaderProgram(shaderProgram.name);
	for (var shaderI = 0; shaderI < shaderProgram.shaders.length; shaderI++)
	{
		var shader = shaderProgram.shaders[shaderI];
		addShaderToProgramByName(shaderProgram.name, shader.name, shader.filename);
	}
}


for (var effectI = 0; effectI < demoScript.effects.length; effectI++)
{
	var effect = demoScript.effects[effectI];
	if (effect.skip === true)
	{
		continue;
	}

	addPlayerEffect(effect.name, effect.reference);
}

for (var sceneI = 0; sceneI < demoScript.scenes.length; sceneI++)
{
	var scene = demoScript.scenes[sceneI];
	
	if (scene.skip === true)
	{
		continue;
	}

	addPlayerScene("", scene.name, scene.effect, scene.startTime, scene.durationTime);
	processVariables(scene);

	if (!scene.hasOwnProperty("effect"))
	{
		for (var subSceneI = 0; subSceneI < scene.scenes.length; subSceneI++)
		{
			var subScene = scene.scenes[subSceneI];
			if (subScene.skip === true)
			{
				continue;
			}

			addPlayerScene(scene.name, subScene.name, subScene.effect, subScene.startTime, subScene.durationTime);
			processVariables(subScene);
		}
	}
}
