precision highp float;
uniform sampler2D mixerTex;
uniform float iGlobalTime;
uniform vec2 iResolution;
vec2 iMouse = vec2(sin(iGlobalTime*0.1),0.7);

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
mat2 rotate(float Angle)
{
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
    return rotation;
}
float sdCapsule( vec2 p, vec2 a, vec2 b, float r ){
    vec2 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return min(floor(length( pa - ba*h ) - r),0.);
}


float smin( float a, float b, float k ){
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}
mat3 rotY(in float a) {
    return mat3( cos(a), 0.0, sin(a),
                 0.0,    1.0, 0.0,
                -sin(a), 0.0, cos(a)
                );
}
float udRoundBox( vec3 p, vec3 b, float r ){
  return length(max(abs(p)-b,0.0))-r;
}
float sdSphere( vec3 p, float s ){
  return length(p)-s;
}
float sdBox( vec3 p, vec3 b ){
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}
float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}
float sdCapsule( vec3 p, vec3 a, vec3 b, float r ){
    vec3 pa = p - a , ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}
float sdPlane( vec3 p, vec4 n )
{
  return dot(p,n.xyz) + n.w;
}

float palkki(in vec3 p){
    
    float finalDistance = 10000000.;
    
    finalDistance = min(finalDistance, sdBox( p/(1.0+p.y/3.), vec3(12.0,25.0,2.0) ) );
    vec3 p2 = p;
    vec3 p3 = p;
    vec3 p4 = p;
    
    p3.zxy *= rotY(3.14145*0.5);
    p3.zyx *= rotY(3.14145*0.5);
    p2.zxy *= rotY(3.14145*0.25);
    p.zyx *= rotY(3.14145*0.5);
    finalDistance = min(finalDistance, udRoundBox( (p-vec3(1.0,-2.8,0.0)), vec3(0.8,3.0,1.8) , 0.1 ) );
    finalDistance = min(finalDistance, udRoundBox( (p3-vec3(1.0,-2.8,0.0)), vec3(1.8,6.0,0.7) , 0.1 ) );
    finalDistance = min(finalDistance, udRoundBox( (p2-vec3(2.0,-2.8,0.0)), vec3(1.8,6.0,2.7) , 0.1 ) );
    
    
    return finalDistance;
}
void objectGroup0(in vec3 p, out vec3 color, out float reflectiveValue, out float finalDistance){
    
    float dist1 = 1e9;
    finalDistance = dist1;
    color = vec3(1.2, 1.0, 0.8);
    
    vec3 p2 = vec3(mod(p.x-4.,8.),p.y,abs(p.z*0.6));
    p2.zy *= rotate(p.x/(66.+iGlobalTime/4.));
    finalDistance = min(finalDistance,palkki(p2-vec3(5.0,3.0,7.0+rand(vec2(floor(p.yx*2.)))/16.)));

    float dist2 = 1e9;
    vec3 pmag = p-vec3(10.+-iGlobalTime/1.8,0.,0.);
    pmag *=rotY(iGlobalTime/2.);
    pmag.zxy *=rotY(iGlobalTime/2.4);
    
    dist2 = min(dist2,  udBox(pmag, vec3(2.)) );
    
    finalDistance=min(finalDistance, dist2);
    reflectiveValue = 0.8;
}


float calculateDistance(in vec3 p, out vec3 color, out float reflectiveValue) {
    float finalDistance = 10000000.;
    
    objectGroup0(p,color,reflectiveValue,finalDistance);
    return finalDistance;
}


float traceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource){
    vec3 ro = rayPosition + normalVector*0.01;
    vec3 rd = normalize(lightSource - rayPosition);
    float t = 0.01;
    float k = 1.6;
    float res = 1.0;
    for( int i=0; i<22; i++ )
    {
        vec3 C;
        float dummy;
        float h = calculateDistance(ro + rd*t, C, dummy);
        h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.01, 0.9 );
        if( h<0.0001) break;
    }
    return clamp(res,0.01,4.0);
}
vec3 tracer(vec3 rayStartPosition, vec3 rayDirection) {
    const float epsilon = 0.001;
    
    vec3 rayPosition = rayStartPosition;

    vec3 normalVector;
    float dist = 0.0;
    vec3 returnColor = vec3(0.0);
    vec3 finalColor = vec3(0.0);
    vec3 lightSource = vec3(-33.,1.,1.) ;
    float reflectiveValue = 1.0;
    float reflectionNow = 1.0;
    float finalLight = 1.0;
    
    float possibleFogLight = 1.0;
    
    for(float k=0.; k<1.; k++) {
        for(float i=0.; i<66.; i++) {
            vec3 color;
            float stepable = calculateDistance(rayPosition, color, reflectiveValue);
            dist += stepable;
            rayPosition = rayStartPosition + dist * rayDirection;
            
                vec3 lightDir = (lightSource-rayStartPosition);
                lightDir = normalize(lightDir);
                float directLight = dot(rayDirection, lightDir);
                returnColor += max( -rayPosition.x * length(rayPosition.zy) * 0.0002*clamp( min(max( pow(directLight,77.1+sin(rayPosition.x/2.+rayPosition.z+iGlobalTime)*88.) * vec3(1.7,1.1,.9) * 0.2, 0.01),1.), vec3(0.04), vec3(1.0)), vec3(0.));
                
            if( abs(stepable) <= epsilon){
                vec3 C;
                float dummy = 0.0;
                normalVector = vec3(    calculateDistance(rayPosition+vec3(epsilon,0,0),C,dummy)-calculateDistance(rayPosition+vec3(-epsilon,0,0),C,dummy),
                                        calculateDistance(rayPosition+vec3(0,epsilon,0),C,dummy)-calculateDistance(rayPosition+vec3(0,-epsilon,0),C,dummy),
                                        calculateDistance(rayPosition+vec3(0,0,epsilon),C,dummy)-calculateDistance(rayPosition+vec3(0,0,-epsilon),C,dummy));
                normalVector = normalize(normalVector);
                float light = traceToLight(rayPosition, normalVector, lightSource);
                finalLight = min(finalLight, light);
                float lightDistance = distance(rayStartPosition,lightSource);
                
                finalColor = color * vec3(dot(normalVector, -rayDirection));
                
                
                vec3 lightDir = (lightSource-rayPosition);
                lightDir = normalize(lightDir);
                float directLight = dot(normalVector, lightDir);
                reflectionNow = max(reflectionNow,reflectiveValue);
                
                
                returnColor += ( vec3(finalLight*max(1.5*directLight*vec3(1.7,1.1,0.9),0.01)) / (k*4.8/reflectionNow + 1.0)) * finalColor;
  
                break;
                
            }
        }
        dist = 0.01;
        rayStartPosition = rayPosition + normalVector;
        rayPosition = rayStartPosition;
        rayDirection = reflect(rayDirection, normalVector);
    } 
    vec3 lightDir = (lightSource-rayStartPosition);
    lightDir = normalize(lightDir);
    float directLight = dot(rayDirection, lightDir);
    returnColor+=min(max( pow(directLight,22.1) * vec3(1.7,1.1,.9) * 0.08, 0.01),1.);
               
    return returnColor;
}

vec3 piip() {
    vec3 cameraPosition = vec3( 3.-iGlobalTime/(2.+iGlobalTime), 3., -19.+iGlobalTime/3.);
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    
    float aspect = iResolution.x / iResolution.y;
    vec3 direction = normalize(vec3(.5 * uv * vec2(aspect, 1.0), 1. ));
    
    cameraPosition *= rotY(-3.141/2.);
    direction *= rotY(-3.141/2.);
    direction.xzy *= rotY(-0.24-iGlobalTime/88.);
    direction.zxy *= rotY(-iGlobalTime/35.);
    return min(iGlobalTime/8.,1.)*tracer(cameraPosition, direction);
}








void main(){
    
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    float aspect = iResolution.x / iResolution.y;
    vec3 p=piip();
        gl_FragColor = vec4(pow(p,vec3(1.1))*4.5,1.);
}