var filter = require('through2-filter').obj;
var Set = require('es6-set');

function prop(propName) {
  return function (data) {
    return data[propName];
  };
}

module.exports = unique;
function unique(propName, keyStore) {
  keyStore = keyStore || new Set();

  var keyfn = JSON.stringify;
  if (typeof propName === 'string') {
    keyfn = prop(propName);
  } else if (typeof propName === 'function') {
    keyfn = propName;
  }

  return filter(function (data) {
    var key = keyfn(data);

    if (keyStore.has(key)) {
      return false;
    } else {
      keyStore.add(key);
      return true;
    }
  });
}
