/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.effects;

import ddf.minim.Minim;
import ddf.minim.effects.IIRFilter;

public class ChebFilter
extends IIRFilter {
    public static final int LP = 1;
    public static final int HP = 2;
    private static final float PI = (float)Math.PI;
    private static final float TWO_PI = (float)Math.PI * 2;
    private int type;
    private int poles;
    private float ripple;
    float[] ca = new float[23];
    float[] cb = new float[23];
    float[] ta = new float[23];
    float[] tb = new float[23];
    float[] pa = new float[3];
    float[] pb = new float[2];

    public ChebFilter(float f, int n, float f2, int n2, float f3) {
        super(f, f3);
        this.type = n;
        this.ripple = f2;
        this.poles = n2;
    }

    public void setType(int n) {
        if (n != 1 && n != 2) {
            Minim.error("Invalid filter type, defaulting to low pass.");
            n = 1;
        }
        if (this.type != n) {
            this.type = n;
            this.calcCoeff();
        }
    }

    public int getType() {
        return this.type;
    }

    public void setRipple(float f) {
        if (this.ripple != f) {
            this.ripple = f;
            this.calcCoeff();
        }
    }

    public float getRipple() {
        return this.ripple;
    }

    public void setPoles(int n) {
        if (n < 2) {
            Minim.error("ChebFilter.setPoles: The number of poles must be at least 2.");
            return;
        }
        if (n % 2 != 0) {
            Minim.error("ChebFilter.setPoles: The number of poles must be even.");
            return;
        }
        if (n > 20) {
            Minim.error("ChebFilter.setPoles: The maximum number of poles is 20.");
        }
        this.poles = n;
        this.calcCoeff();
    }

    public int getPoles() {
        return this.poles;
    }

    @Override
    protected synchronized void calcCoeff() {
        int n;
        for (n = 0; n < 23; ++n) {
            this.tb[n] = 0.0f;
            this.ta[n] = 0.0f;
            this.cb[n] = 0.0f;
            this.ca[n] = 0.0f;
        }
        this.ca[2] = 1.0f;
        this.cb[2] = 1.0f;
        for (n = 1; n <= this.poles / 2; ++n) {
            this.calcTwoPole(n, this.pa, this.pb);
            System.arraycopy(this.ca, 0, this.ta, 0, this.ta.length);
            System.arraycopy(this.cb, 0, this.tb, 0, this.tb.length);
            for (int i = 2; i < 23; ++i) {
                this.ca[i] = this.pa[0] * this.ta[i] + this.pa[1] * this.ta[i - 1] + this.pa[2] * this.ta[i - 2];
                this.cb[i] = this.tb[i] - this.pb[0] * this.tb[i - 1] - this.pb[1] * this.tb[i - 2];
            }
        }
        this.cb[2] = 0.0f;
        for (n = 0; n < 21; ++n) {
            this.ca[n] = this.ca[n + 2];
            this.cb[n] = -this.cb[n + 2];
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < 21; ++i) {
            if (this.type == 1) {
                f += this.ca[i];
                f2 += this.cb[i];
                continue;
            }
            f += this.ca[i] * (float)Math.pow(-1.0, i);
            f2 += this.cb[i] * (float)Math.pow(-1.0, i);
        }
        float f3 = f / (1.0f - f2);
        int n2 = 0;
        while (n2 < 21) {
            int n3 = n2++;
            this.ca[n3] = this.ca[n3] / f3;
        }
        if (this.a == null || this.a.length != this.poles + 1) {
            this.a = new float[this.poles + 1];
        }
        if (this.b == null || this.b.length != this.poles) {
            this.b = new float[this.poles];
        }
        System.arraycopy(this.ca, 0, this.a, 0, this.a.length);
        System.arraycopy(this.cb, 1, this.b, 0, this.b.length);
    }

    private void calcTwoPole(int n, float[] fArray, float[] fArray2) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13 = this.poles;
        float f14 = (float)Math.PI / (f13 * 2.0f) + (float)(n - 1) * (float)Math.PI / f13;
        float f15 = -((float)Math.cos(f14));
        float f16 = (float)Math.sin(f14);
        if (this.ripple > 0.0f) {
            f12 = 100.0f / (100.0f - this.ripple);
            f11 = f12 * f12;
            f10 = 1.0f / (float)Math.sqrt(f11 - 1.0f);
            f9 = 1.0f / f13;
            f8 = f10 * f10;
            f7 = f9 * (float)Math.log((double)f10 + Math.sqrt(f8 + 1.0f));
            f6 = f9 * (float)Math.log((double)f10 + Math.sqrt(f8 - 1.0f));
            f5 = (float)Math.exp(f6);
            f4 = (float)Math.exp(-f6);
            f6 = (f5 + f4) * 0.5f;
            f3 = (float)Math.exp(f7);
            f2 = (float)Math.exp(-f7);
            f = 1.0f / f6;
            f15 *= (f3 - f2) * 0.5f * f;
            f16 *= (f3 + f2) * 0.5f * f;
        }
        f12 = 2.0f * (float)Math.tan(0.5);
        f11 = (float)Math.PI * 2 * (this.frequency() / this.sampleRate());
        f10 = f15 * f15 + f16 * f16;
        f9 = 4.0f * f15 * f12;
        f8 = f12 * f12;
        f7 = f10 * f8;
        f6 = 2.0f * f8;
        f5 = 4.0f - f9 + f7;
        f4 = 1.0f / f5;
        f3 = f8 * f4;
        f2 = f6 * f4;
        f = f3;
        float f17 = (8.0f - f6 * f10) * f4;
        float f18 = (-4.0f - f9 - f7) * f4;
        float f19 = f11 * 0.5f;
        float f20 = this.type == 2 ? -((float)Math.cos(f19 + 0.5f)) / (float)Math.cos(f19 - 0.5f) : (float)Math.sin(0.5f - f19) / (float)Math.sin(0.5f + f19);
        float f21 = f20 * f20;
        float f22 = f2 * f20;
        float f23 = 2.0f * f20;
        float f24 = f17 * f20;
        f5 = 1.0f + f24 - f18 * f21;
        f4 = 1.0f / f5;
        fArray[0] = (f3 - f22 + f * f21) * f4;
        fArray[1] = (-f23 * f3 + f2 + f2 * f21 - f23 * f) * f4;
        fArray[2] = (f3 * f21 - f22 + f) * f4;
        fArray2[0] = (f23 + f17 + f17 * f21 - f18 * f23) * f4;
        fArray2[1] = (-f21 - f24 + f18) * f4;
        if (this.type == 2) {
            fArray[1] = -fArray[1];
            fArray2[0] = -fArray2[0];
        }
    }
}

