/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;
import ddf.minim.ugens.Waves;

public class Flanger
extends UGen {
    public UGen.UGenInput audio = this.addAudio();
    public UGen.UGenInput delay;
    public UGen.UGenInput rate;
    public UGen.UGenInput depth;
    public UGen.UGenInput feedback;
    public UGen.UGenInput dry;
    public UGen.UGenInput wet;
    private float[] delayBuffer;
    private int outputFrame;
    private int bufferFrameLength;
    private float step;
    private float stepSize;
    private float prevFreq;
    private float oneOverSampleRate;

    public Flanger(float f, float f2, float f3, float f4, float f5, float f6) {
        this.delay = this.addControl(f);
        this.rate = this.addControl(f2);
        this.depth = this.addControl(f3);
        this.feedback = this.addControl(f4);
        this.dry = this.addControl(f5);
        this.wet = this.addControl(f6);
    }

    private void resetBuffer() {
        int n = (int)(100.0f * this.sampleRate() / 1000.0f);
        this.delayBuffer = new float[n * this.audio.channelCount()];
        this.outputFrame = 0;
        this.bufferFrameLength = n;
    }

    private float getRate() {
        float f = this.rate.getLastValue();
        return f > 0.001f ? f : 0.001f;
    }

    @Override
    protected void sampleRateChanged() {
        this.resetBuffer();
        this.oneOverSampleRate = 1.0f / this.sampleRate();
        this.stepSize = this.getRate() * this.oneOverSampleRate;
        this.prevFreq = this.getRate();
        this.step = 0.25f;
    }

    private void updateStepSize() {
        float f = this.getRate();
        if (this.prevFreq != f) {
            this.stepSize = f * this.oneOverSampleRate;
            this.prevFreq = f;
        }
    }

    @Override
    protected void channelCountChanged() {
        this.resetBuffer();
    }

    @Override
    protected void uGenerate(float[] fArray) {
        float f = Waves.SINE.value(this.step);
        float f2 = this.depth.getLastValue() * 0.5f;
        float f3 = this.delay.getLastValue() + (f * f2 + f2);
        int n = (int)(f3 * this.sampleRate() / 1000.0f);
        for (int i = 0; i < fArray.length; ++i) {
            int n2 = this.outputFrame * this.audio.channelCount() + i;
            float f4 = this.audio.getLastValues()[i];
            float f5 = this.delayBuffer[n2];
            int n3 = ((this.outputFrame + n) * this.audio.channelCount() + i) % this.delayBuffer.length;
            this.delayBuffer[n3] = f4 + f5 * this.feedback.getLastValue();
            fArray[i] = f4 * this.dry.getLastValue() + f5 * this.wet.getLastValue();
        }
        ++this.outputFrame;
        if (this.outputFrame == this.bufferFrameLength) {
            this.outputFrame = 0;
        }
        this.updateStepSize();
        this.step += this.stepSize;
        if (this.step > 1.0f) {
            this.step -= 1.0f;
        }
    }
}

