struct VSOutput
{
	float4 PositionCS : SV_POSITION;
	float2 TexCoord : texcoord0;
};
Texture2D InputTexture0:register(t0);
Texture2D InputTexture1:register(t1);
SamplerState sm:register(s0);

float4 p(VSOutput input) : SV_TARGET
{
	float3 c = InputTexture0.Sample(sm, input.TexCoord) * sceneStrength *sceneColor +
	InputTexture1.Sample(sm, input.TexCoord) * blurStrength * blurColor;
	c = lerp(c,c*tonemapColor/(1+c),tonemapStrength);
	return float4(c,1);
}