#!/usr/bin/python
from __future__ import absolute_import, division, print_function, unicode_literals

""" Example showing what can be left out. ESC to quit"""
#import demo
import pi3d

import time, glob, threading
from subprocess import Popen, PIPE, STDOUT

from math import sin, cos, tan
import random
import numpy as np


FPS = 30
BPM = 120

DISPLAY = pi3d.Display.create(frames_per_second=FPS)
DISPLAY.set_background(0.1,0.1,0.1,1)

shader = pi3d.Shader("uv_flat")
flatsh = pi3d.Shader("uv_flat")

sppFlag = pi3d.ImageSprite("textures/smpp.png", shader, w=640.0, h=480)
sppStar = pi3d.ImageSprite("textures/star.png", shader, w=160.0, h=160.0)
sppSkull = pi3d.ImageSprite("textures/head.png", shader, w=66.0, h=75)
sppFlagga = pi3d.ImageSprite("textures/smpp-all.png", shader, w=640.0, h=480.0)


sppFlagga.position(0,0,300)
sppFlagga.scale(0.2,0.15,0.15)
sppLogo = [sppFlag,sppStar,sppSkull]
for i in range(len(sppLogo)):
	if(i==0):
		sppLogo[i].position(0,0,300)
		sppLogo[i].scale(0.2,0.15,0.15)
	else:
		sppLogo[i].scale(0.15,0.15,0.15)
		sppLogo[i].position(-40,20,300-i)

ASPECT = DISPLAY.width / DISPLAY.height
camera = pi3d.Camera((0,0,0), (0,0,-0.1),(1,1000,15,ASPECT),is_3d=True)
ortho_cam = pi3d.Camera(is_3d=False)

##Create some cubes
kuber = []
kKub = pi3d.MergeShape()
k_dist = 0.1
k_size = 5*k_dist
kub = pi3d.Cuboid(w=4,h=4,d=4)
#kub = pi3d.Sphere(radius=1,slices=3,sides=3,z=1)

#music stuff
class musicThread (threading.Thread):
	def __init__(self, threadID, name):
		threading.Thread.__init__(self)
		self.threadID = threadID
		self.name = name
		self.p = Popen([b"mpg123",b"-R"], stdout=PIPE, stdin=PIPE)#b"-R", b"-@", b"testPlayer"], stdout=PIPE, stdin=PIPE)
		self.p.stdin.write(bytearray("LOAD music/song.mp3\n", "ascii"))
		self.p.stdin.flush()
	def run(self):
		flg = True
		while flg:
			st_read = time.time()
			l = self.p.stdout.readline()
			if (time.time() - st_read) > 0.01:# poss pause in animation waiting for mpg321 info
				flg = False

mThread = musicThread(1,"mThread")
mThread.start()




cubeArray = []
positionArray = []
cubeArrayLength = 7
cubeArrayHeight = 12
for i in range(cubeArrayHeight):
	cubeArray.append([])
	positionArray.append([])
	for j in range(cubeArrayLength-i):
		positionArray[i].append({"x":i*9-20,"y":j*9-10,"z":0})
		cubeArray[i].append(kub)
		cubeArray[i][j].position(positionArray[i][j]["x"],positionArray[i][j]["y"],positionArray[i][j]["z"])
spiralSteps = 12
zLen = 190.0


rot=0.0
mykeys = pi3d.Keyboard()
frames = 0
beats = 2
trail = 1

tick = 0
next_time = time.time() + 2.1

fpsMessage = "hej, jag är en sträng"

font = pi3d.Font("fonts/FreeMonoBoldOblique.ttf", (80,20,170,255), add_codepoints=[256])
font2 = pi3d.Font("fonts/FreeMonoBoldOblique.ttf", (80,60,40,255), add_codepoints=[256])
font3 = pi3d.Font("fonts/FreeMonoBoldOblique.ttf", (255,255,255,255), add_codepoints=[256])

fpsString = pi3d.String(font=font,string=fpsMessage,camera=ortho_cam, z=1.0,
				is_3d=False,justify="r")
fpsString.set_shader(flatsh)

frameMessage = "Frame: ______"
frameString = pi3d.String(font=font,string=frameMessage,camera=ortho_cam, z=1.0,
				is_3d=False,justify="r")
frameString.set_shader(flatsh)
frameString.position(-DISPLAY.width/2+300,-DISPLAY.height/2+50.0,1.0)

kub.position(0,0,0)
kub.translate(0,-600,10)

greetz = [	"dunz0r",
			"Memory Leek",
			"OelTrucken",
			"EDISON crew",
			#"jojo",
			#"FoodTrucken",
			#"BeerTrucken",
			"Husvagn Crew",
			"Alla n00b c0derz",
			"Birdie"
			#"Mamma",
			#"Matematik"
]

#greetzS = "_.-+-._.-+-._.-+"
#greet_spacer = " |+-._.-+"
greetzS = " +"
greet_spacer = "+"
for i in range(len(greetz)):
	greetzS = greetzS + greetz[i] + greet_spacer
#greetzS += "-._.-+-._.-+-._"
#greetzS = greetzS.split()
#print(greetzS)
introStringText = [	"This is our second demo",
					"By the SoMalian Pirate Party",
					"Now on a Raspberry Pi 2",
					"",
					"Välfarden börjar vid 15 fps",
					"From Uppsala with <3"]
introString = []
for i in range(len(introStringText)):
	introString.append(pi3d.String(font = font2, string=introStringText[i], camera=ortho_cam, z=1.0, is_3d=False, justify="c"))
	introString[i].position(0,-550-60*i,0)
	introString[i].set_shader(flatsh)

credString = []
credStringText = [	".k0d & .z1k - broink",
					".gfx - malen",
					".supp0rt - Somalian Government"]

for i in range(len(credStringText)):
	credString.append(pi3d.String(font = font3, string=credStringText[i], camera=ortho_cam, z=1.0,is_3d=False,justify="c"))
	credString[i].position(0,-40*i,1)
	credString[i].set_shader(flatsh)
slutString = []
slutStringText = [	"Den e slut nu",
					"tryck eskajp",
					"eller njut av tystnaden som kommer snart"]

for i in range(len(slutStringText)):
	slutString.append(pi3d.String(font = font3, string=slutStringText[i], camera=ortho_cam, z=1.0,is_3d=False,justify="c"))
	slutString[i].position(0,-40*i,1)
	slutString[i].set_shader(flatsh)

greetzString = []
for i in range(len(greetzS)):
	greetzString.append(pi3d.String(font = font, string=greetzS[i], camera=ortho_cam, z=1.0,is_3d=False,justify="r"))
	greetzString[i].set_shader(flatsh)
	greetzString[i].position(len(greetzS)*25 + 1200,10,10)

# torkare = pi3d.MergeShape(name="torkare")
# for i in range(len(positionArray)):
# 	for j in range(len(positionArray[i])):
# 		pos = positionArray[i][j]
# 		torkare.add(kub,x=pos["x"]*1.1,y=pos["y"],z=pos["z"])
# 		torkare.add(kub,x=pos["x"]+j*9+67,y=pos["y"],z=pos["z"])

# torkare.set_draw_details(shader,[earth])
# torkare.position(-48,-10,-10)
# torkare.rotateIncX(-90)



while DISPLAY.loop_running():
	frames +=1
	rot = rot + 0.01
	DISPLAY.clear()
	#frame.draw()
	if(frames < 530):
		for i in  range(len(sppLogo)):
			if(i == 1):
				sppLogo[i].rotateIncZ(10)
			if(i == 2):
				sppLogo[i].position(sppLogo[i].x(),sppLogo[i].y()+sin(frames/6)/2,sppLogo[i].z())
			sppLogo[i].draw()
		if(frames > 210):
			for i in range(len(introString)):
				introString[i].translateY(4.5)
				introString[i].translateX(sin((frames+i*25)/25)*8.5)
				introString[i].draw()
	elif(frames < 720):
		
		for i in range(len(positionArray)):
			for j in range(len(positionArray[i])):
				pos = positionArray[i][j]
				xTrans = abs(sin((frames-32)/16))*10*j*0.9
				yTrans = abs((sin(frames/2))*3)*j
				kub.position(pos["x"],pos["y"],pos["z"])
				kub.translate(-40,-20,300)
				kub.translateX(xTrans)
				kub.rotateIncZ(10)
				kub.translateY(yTrans)
				kub.draw()
				kub.position(pos["x"]+j*9,pos["y"],pos["z"])
				kub.translate(-40,-20,300)
				kub.translateX(67)
				kub.translateX(-xTrans)
				kub.translateY(yTrans)
				kub.rotateIncZ(-20)
				kub.draw()
	elif(frames < 1250):
		for i in reversed(range(len(greetzS))):
			greetzString[len(greetzS)-i-1].translateX(-i*30)
			greetzString[len(greetzS)-i-1].positionY(sin((frames*2+i*2)/25)*220)
			greetzString[len(greetzS)-i-1].draw()
			greetzString[len(greetzS)-i-1].translateX(i*30-10)
	elif(frames < 1550):
		DISPLAY.set_background(0.0,0.0,0.0,1.0)
		for i in range(len(credString)):
			credString[i].draw()
	else:
		DISPLAY.set_background(0.0,0.0,0.0,1.0)
		for i in range(len(slutString)):
			slutString[i].draw()
	

	#fpsString.draw()
	
	#frameString.draw()
	#frameMessage = "Frame: " + str(frames)
	#frameString.quick_change(frameMessage)

	# if time.time() > next_time:
	# 	fpsMessage = "FPS: " + str(tick / 2)
	# 	fpsString.quick_change(fpsMessage)
	# 	tick = 0
	# 	next_time = time.time() + 2.0
	# tick += 1

	#Demokod here
	#drawcode here
	if mykeys.read() == 27:
		mykeys.close()
		DISPLAY.destroy()
		break
