#include <QGuiApplication>
#include <QQmlComponent>
#include <QQmlEngine>
#include <QWindow>
#include <QDebug>

#include "TileItem.h"
#include "Game.h"
#include "Tile.h"
#include "QRCodeItem.h"
#include "PlayerHandler.h"
#include "Player.h"
#include "Server.h"
#include "UrlHelper.h"
#include "BoardViewModel.h"
#include "ActionVisualizer.h"
#include "ScoreHandler.h"
#include "QStringEx.h"

int main(int argc, char **argv)
{
	QGuiApplication application(argc, argv);
//	application.setOverrideCursor(Qt::BlankCursor);

	qmlRegisterType<TileItem>("AvoidPointer", 1, 2, "TileItem");
	qmlRegisterType<Game>("AvoidPointer", 1, 2, "Game");
	qmlRegisterType<QRCodeItem>("AvoidPointer", 1, 2, "QRCodeItem");
	qmlRegisterType<BoardViewModel>("AvoidPointer", 1, 2, "BoardViewModel");

	qmlRegisterType<Tile>();
	qmlRegisterType<PlayerHandler>();
	qmlRegisterType<Player>();
	qmlRegisterType<Server>();
	qmlRegisterType<TileHandler>();
	qmlRegisterType<ActionVisualizer>();
	qmlRegisterType<ScoreHandler>();

	qmlRegisterSingletonType<UrlHelper>("AvoidPointer", 1, 2, "UrlHelper", &UrlHelper::qmlInstance);

	QQmlEngine engine;
	QQmlComponent component(&engine, "Window.qml");

	qDebug() << component.errorString();

	QWindow *window = (QWindow *)component.create();
	window->showFullScreen();

	return application.exec();
}
