import QtQuick 2.0
import QtQuick.Window 2.0
import QtGraphicalEffects 1.0
import AvoidPointer 1.2

Window
{
	width: 1920
	height: 1080

	Game
	{
		id: game
	}

	Board
	{
		anchors
		{
			fill: parent
		}
	}

	PlayerSelectionState
	{
		anchors
		{
			fill: parent
		}

		opacity: game.started ? 0 : 1
		visible: opacity >0

		Behavior on opacity
		{
			PropertyAnimation
			{
				duration: 200
			}
		}
	}

	GameOverState
	{
		anchors
		{
			fill: parent
		}

		opacity: game.gameOver ? 1 : 0
		visible: opacity > 0

		Behavior on opacity
		{
			PropertyAnimation
			{
				duration: 200
			}
		}
	}

	Rectangle
	{
		anchors
		{
			fill: parent
		}

		id: overlay
		color: "#AA000000"
		opacity: 0
		visible: opacity > 0

		Rectangle
		{
			anchors
			{
				left: parent.left
				right: parent.right
				verticalCenter: parent.verticalCenter
			}

			color: game.player.color
			id: announcement

			Behavior on color
			{
				SequentialAnimation
				{
					ParallelAnimation
					{
						NumberAnimation
						{
							target: overlay
							property: "opacity"
							to: 1
						}

						NumberAnimation
						{
							easing
							{
								type: Easing.InQuad
							}

							target: announcement
							property: "height"
							to: 200
						}
					}

					PauseAnimation
					{
						duration: 500
					}

					ParallelAnimation
					{
						NumberAnimation
						{
							target: overlay
							property: "opacity"
							to: 0
						}

						NumberAnimation
						{
							easing
							{
								type: Easing.OutQuad
							}

							target: announcement
							property: "height"
							to: 100
						}
					}
				}
			}
		}
	}
}
