#include <QHostInfo>
#include <QDebug>
#include <QNetworkInterface>

#include "UrlHelper.h"
#include "QStringEx.h"
#include "Player.h"

QObject *UrlHelper::qmlInstance(QQmlEngine *engine, QJSEngine *scriptEngine)
{
	Q_UNUSED(engine);
	Q_UNUSED(scriptEngine);

	return new UrlHelper();
}

QString UrlHelper::getUrl(const QString &action, int index) const
{
	const QNetworkInterface &interface = findInterface();
	const QList<QNetworkAddressEntry> &addresses = interface.addressEntries();

	if (!addresses.isEmpty())
	{
		const QNetworkAddressEntry &entry = addresses[0];
		const QHostAddress &address = entry.ip();
		const QString &url = QStringEx::format("http://%1:8080/%2/%3", address, action, index);

		return url;
	}

	return QString();
}

QString UrlHelper::getUrl(const QString &action, Player *player) const
{
	if (player)
	{
		return getUrl(action, *player);
	}

	return QString();
}

QNetworkInterface UrlHelper::findInterface() const
{
	const QList<QNetworkInterface> &interfaces = QNetworkInterface::allInterfaces();

	for (const QNetworkInterface &interface : interfaces)
	{
		const QNetworkInterface::InterfaceFlags flags = interface.flags();

		if (!(flags & QNetworkInterface::IsLoopBack) && flags & QNetworkInterface::IsUp)
		{
			qDebug() << interface.name();

			return interface;
		}
	}

	return QNetworkInterface();
}
