#include <random>
#include <algorithm>

#include "TileStack.h"
#include "Tile.h"
#include "TileHandler.h"

TileStack::TileStack()
{
	const int count = (SIZE * SIZE) / 5;

	for (int i = 0; i < count; i++)
	{
		m_tiles << (Tile::Left | Tile::Right);
	}

	for (int i = 0; i < count; i++)
	{
		m_tiles << Tile::Top;
	}

	for (int i = 0; i < count; i++)
	{
		m_tiles << (Tile::Top | Tile::Right);
	}

	for (int i = 0; i < count; i++)
	{
		m_tiles << (Tile::Right | Tile::Top | Tile::Bottom);
	}

	for (int i = 0; i < count; i++)
	{
		m_tiles << (Tile::Left | Tile::Bottom | Tile::Top | Tile::Right);
	}

	std::random_device rd;
	std::mt19937 g(rd());

	std::shuffle(m_tiles.begin(), m_tiles.end(), g);
}

int TileStack::take()
{
	return m_tiles.takeFirst();
}

