#ifndef TILEITEM_H
#define TILEITEM_H

#include <QQuickPaintedItem>

const int TILE_SIZE = 32;
const int SCALE = 2;

class TileItem : public QQuickPaintedItem
{
	Q_OBJECT

	Q_PROPERTY(int entrance READ entrance WRITE setEntrance NOTIFY entranceChanged)
	Q_PROPERTY(QColor color READ color WRITE setColor NOTIFY colorChanged)
	Q_PROPERTY(bool active READ active WRITE setActive NOTIFY activeChanged)

	public:
		TileItem();

		int entrance() const;
		void setEntrance(int entrance);

		QColor color() const;
		void setColor(const QColor &color);

		bool active() const;
		void setActive(bool active);

		void paint(QPainter *painter) override;

	private:
		int m_entrance;
		QColor m_color;
		bool m_active;

	signals:
		void entranceChanged();
		void colorChanged();
		void activeChanged();
};

#endif // TILE_H
