#include <QPainter>

#include "TileItem.h"
#include "Tile.h"

TileItem::TileItem()
	: m_entrance(Tile::None)
	, m_active(false)
{
	setWidth(TILE_SIZE * SCALE);
	setHeight(TILE_SIZE * SCALE);
}

int TileItem::entrance() const
{
	return m_entrance;
}

void TileItem::setEntrance(int entrance)
{
	m_entrance = entrance;

	update();
}

QColor TileItem::color() const
{
	return m_color;
}

void TileItem::setColor(const QColor &color)
{
	m_color = color;

	update();
}

bool TileItem::active() const
{
	return m_active;
}

void TileItem::setActive(bool active)
{
	m_active = active;

	update();
}

void TileItem::paint(QPainter *painter)
{
	const QRectF bounds(0, 0, TILE_SIZE, TILE_SIZE);
	const QRectF &adjusted = bounds.adjusted(1, 1, -1, -1);

	painter->scale(SCALE, SCALE);

	painter->setPen(Qt::white);
	painter->setBrush(m_color);
	painter->drawRect(adjusted);

	painter->setRenderHint(QPainter::Antialiasing);
	painter->setOpacity(0.3);

	switch (m_entrance)
	{
		case Tile::Left | Tile::Right:
		{
			QPainterPath path;
			path.moveTo(2, 6);
			path.lineTo(TILE_SIZE - 2, 6);
			path.moveTo(2, TILE_SIZE - 6);
			path.lineTo(TILE_SIZE - 2, TILE_SIZE - 6);

			QPainterPath path1;
			path1.moveTo(2, 7);
			path1.lineTo(TILE_SIZE - 2, 7);
			path1.moveTo(2, TILE_SIZE - 7);
			path1.lineTo(TILE_SIZE - 2, TILE_SIZE - 7);

			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setPen(Qt::black);
			painter->drawPath(path1);

			painter->setPen(Qt::NoPen);
			painter->setBrush(Qt::black);
			painter->drawRect(1, 7, TILE_SIZE - 2, 18);

			break;
		}

		case Tile::Top | Tile::Bottom:
		{
			QPainterPath path;
			path.moveTo(6, 2);
			path.lineTo(6, TILE_SIZE - 2);
			path.moveTo(TILE_SIZE - 6, 2);
			path.lineTo(TILE_SIZE - 6, TILE_SIZE - 2);

			QPainterPath path1;
			path1.moveTo(7, 2);
			path1.lineTo(7, TILE_SIZE - 2);
			path1.moveTo(TILE_SIZE - 7, 2);
			path1.lineTo(TILE_SIZE - 7, TILE_SIZE - 2);

			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setPen(Qt::black);
			painter->drawPath(path1);

			painter->setPen(Qt::NoPen);
			painter->setBrush(Qt::black);
			painter->drawRect(7, 1, 18, TILE_SIZE - 2);

			break;
		}

		case Tile::Top | Tile::Right:
		{
			QPainterPath path;
			path.moveTo(6, 2);
			path.lineTo(6, TILE_SIZE - 12);
			path.quadTo(6, TILE_SIZE - 6, 11, TILE_SIZE - 6);
			path.lineTo(TILE_SIZE - 2, TILE_SIZE - 6);
			path.moveTo(TILE_SIZE - 2, 6);
			path.quadTo(TILE_SIZE - 6, 6, TILE_SIZE - 6, 2);

			QPainterPath path1;
			path1.moveTo(7, 1);
			path1.lineTo(7, TILE_SIZE - 12);
			path1.quadTo(7, TILE_SIZE - 7, 12, TILE_SIZE - 7);
			path1.lineTo(TILE_SIZE - 1, TILE_SIZE - 7);
			path1.lineTo(TILE_SIZE - 1, 7);
			path1.quadTo(TILE_SIZE - 7, 7, TILE_SIZE - 7, 1);
			path1.lineTo(7, 1);

			QPainterPath path2;
			path2.moveTo(7, 2);
			path2.lineTo(7, TILE_SIZE - 12);
			path2.quadTo(7, TILE_SIZE - 7, 12, TILE_SIZE - 7);
			path2.lineTo(TILE_SIZE - 2, TILE_SIZE - 7);
			path2.moveTo(TILE_SIZE - 2, 7);
			path2.quadTo(TILE_SIZE - 7, 7, TILE_SIZE - 7, 2);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}

		case Tile::Top | Tile::Left:
		{
			QPainterPath path;
			path.moveTo(TILE_SIZE - 6, 2);
			path.lineTo(TILE_SIZE - 6, TILE_SIZE - 12);
			path.quadTo(TILE_SIZE - 6, TILE_SIZE - 6, TILE_SIZE - 11, TILE_SIZE - 6);
			path.lineTo(2, TILE_SIZE - 6);
			path.moveTo(2, 6);
			path.quadTo(6, 6, 6, 2);

			QPainterPath path1;
			path1.moveTo(TILE_SIZE - 7, 1);
			path1.lineTo(TILE_SIZE - 7, TILE_SIZE - 12);
			path1.quadTo(TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 12, TILE_SIZE - 7);
			path1.lineTo(1, TILE_SIZE - 7);
			path1.lineTo(1, 7);
			path1.quadTo(7, 7, 7, 1);
			path1.lineTo(TILE_SIZE - 7, 1);

			QPainterPath path2;
			path2.moveTo(TILE_SIZE - 7, 2);
			path2.lineTo(TILE_SIZE - 7, TILE_SIZE - 12);
			path2.quadTo(TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 12, TILE_SIZE - 7);
			path2.lineTo(2, TILE_SIZE - 7);
			path2.moveTo(2, 7);
			path2.quadTo(7, 7, 7, 2);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}

		case Tile::Bottom | Tile::Right:
		{
			QPainterPath path;
			path.moveTo(6, TILE_SIZE - 2);
			path.lineTo(6, 12);
			path.quadTo(6, 6, 11, 6);
			path.lineTo(TILE_SIZE - 2, 6);
			path.moveTo(TILE_SIZE - 2, TILE_SIZE - 6);
			path.quadTo(TILE_SIZE - 6, TILE_SIZE - 6, TILE_SIZE - 6, TILE_SIZE - 2);

			QPainterPath path1;
			path1.moveTo(7, TILE_SIZE - 1);
			path1.lineTo(7, 12);
			path1.quadTo(7, 7, 12, 7);
			path1.lineTo(TILE_SIZE - 1, 7);
			path1.lineTo(TILE_SIZE - 1, TILE_SIZE - 7);
			path1.quadTo(TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 1);
			path1.lineTo(7, TILE_SIZE - 1);

			QPainterPath path2;
			path2.moveTo(7, TILE_SIZE - 2);
			path2.lineTo(7, 12);
			path2.quadTo(7, 7, 12, 7);
			path2.lineTo(TILE_SIZE - 2, 7);
			path2.moveTo(TILE_SIZE - 2, TILE_SIZE - 7);
			path2.quadTo(TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 2);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}

		case Tile::Bottom | Tile::Left:
		{
			QPainterPath path;
			path.moveTo(TILE_SIZE - 6, TILE_SIZE - 2);
			path.lineTo(TILE_SIZE - 6, 12);
			path.quadTo(TILE_SIZE - 6, 6, TILE_SIZE - 11, 6);
			path.lineTo(2, 6);
			path.moveTo(2, TILE_SIZE - 6);
			path.quadTo(6, TILE_SIZE - 6, 6, TILE_SIZE - 2);

			QPainterPath path1;
			path1.moveTo(TILE_SIZE - 7, TILE_SIZE - 1);
			path1.lineTo(TILE_SIZE - 7, 12);
			path1.quadTo(TILE_SIZE - 7, 7, TILE_SIZE - 12, 7);
			path1.lineTo(1, 7);
			path1.lineTo(1, TILE_SIZE - 7);
			path1.quadTo(7, TILE_SIZE - 7, 7, TILE_SIZE - 1);
			path1.lineTo(TILE_SIZE - 7, TILE_SIZE - 1);

			QPainterPath path2;
			path2.moveTo(TILE_SIZE - 7, TILE_SIZE - 2);
			path2.lineTo(TILE_SIZE - 7, 12);
			path2.quadTo(TILE_SIZE - 7, 7, TILE_SIZE - 12, 7);
			path2.lineTo(2, 7);
			path2.moveTo(2, TILE_SIZE - 7);
			path2.quadTo(7, TILE_SIZE - 7, 7, TILE_SIZE - 2);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}

		case Tile::Top | Tile::Right | Tile::Bottom | Tile::Left:
		{
			QPainterPath path;
			path.moveTo(2, TILE_SIZE - 6);
			path.quadTo(6, TILE_SIZE - 6, 6, TILE_SIZE - 2);
			path.moveTo(TILE_SIZE - 2, TILE_SIZE - 6);
			path.quadTo(TILE_SIZE - 6, TILE_SIZE - 6, TILE_SIZE - 6, TILE_SIZE - 2);
			path.moveTo(TILE_SIZE - 2, 6);
			path.quadTo(TILE_SIZE - 6, 6, TILE_SIZE - 6, 2);
			path.moveTo(2, 6);
			path.quadTo(6, 6, 6, 2);

			QPainterPath path1;
			path1.moveTo(2, TILE_SIZE - 7);
			path1.quadTo(7, TILE_SIZE - 7, 7, TILE_SIZE - 1);
			path1.lineTo(TILE_SIZE - 7, TILE_SIZE - 1);
			path1.quadTo(TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 1, TILE_SIZE - 7);
			path1.lineTo(TILE_SIZE - 1, 7);
			path1.quadTo(TILE_SIZE - 7, 7, TILE_SIZE - 7, 1);
			path1.lineTo(7, 1);
			path1.quadTo(7, 7, 1, 7);
			path1.lineTo(1, TILE_SIZE - 7);

			QPainterPath path2;
			path2.moveTo(2, TILE_SIZE - 7);
			path2.quadTo(7, TILE_SIZE - 7, 7, TILE_SIZE - 2);
			path2.moveTo(TILE_SIZE - 2, TILE_SIZE - 7);
			path2.quadTo(TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 2);
			path2.moveTo(TILE_SIZE - 2, 7);
			path2.quadTo(TILE_SIZE - 7, 7, TILE_SIZE - 7, 2);
			path2.moveTo(2, 7);
			path2.quadTo(7, 7, 7, 2);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}

		case Tile::Bottom | Tile::Left | Tile::Right:
		{
			QPainterPath path;
			path.moveTo(2, TILE_SIZE - 6);
			path.quadTo(6, TILE_SIZE - 6, 6, TILE_SIZE - 2);
			path.moveTo(TILE_SIZE - 2, TILE_SIZE - 6);
			path.quadTo(TILE_SIZE - 6, TILE_SIZE - 6, TILE_SIZE - 6, TILE_SIZE - 2);
			path.moveTo(TILE_SIZE - 2, 6);
			path.lineTo(2, 6);

			QPainterPath path1;
			path1.moveTo(2, TILE_SIZE - 7);
			path1.quadTo(7, TILE_SIZE - 7, 7, TILE_SIZE - 1);
			path1.lineTo(TILE_SIZE - 7, TILE_SIZE - 1);
			path1.quadTo(TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 1, TILE_SIZE - 7);
			path1.lineTo(TILE_SIZE - 1, 7);
			path1.lineTo(1, 7);
			path1.lineTo(1, TILE_SIZE - 7);

			QPainterPath path2;
			path2.moveTo(2, TILE_SIZE - 7);
			path2.quadTo(7, TILE_SIZE - 7, 7, TILE_SIZE - 2);
			path2.moveTo(TILE_SIZE - 2, TILE_SIZE - 7);
			path2.quadTo(TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 2);
			path2.moveTo(TILE_SIZE - 2, 7);
			path2.lineTo(2, 7);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}

		case Tile::Top | Tile::Left | Tile::Right:
		{
			QPainterPath path;
			path.moveTo(2, TILE_SIZE - 6);
			path.lineTo(TILE_SIZE - 2, TILE_SIZE - 6);
			path.moveTo(TILE_SIZE - 2, 6);
			path.quadTo(TILE_SIZE - 6, 6, TILE_SIZE - 6, 2);
			path.moveTo(2, 6);
			path.quadTo(6, 6, 6, 2);

			QPainterPath path1;
			path1.moveTo(2, TILE_SIZE - 7);
			path1.lineTo(TILE_SIZE - 1, TILE_SIZE - 7);
			path1.lineTo(TILE_SIZE - 1, 7);
			path1.quadTo(TILE_SIZE - 7, 7, TILE_SIZE - 7, 1);
			path1.lineTo(7, 1);
			path1.quadTo(7, 7, 1, 7);
			path1.lineTo(1, TILE_SIZE - 7);

			QPainterPath path2;
			path2.moveTo(2, TILE_SIZE - 7);
			path2.lineTo(TILE_SIZE - 2, TILE_SIZE - 7);
			path2.moveTo(TILE_SIZE - 2, 7);
			path2.quadTo(TILE_SIZE - 7, 7, TILE_SIZE - 7, 2);
			path2.moveTo(2, 7);
			path2.quadTo(7, 7, 7, 2);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}

		case Tile::Left | Tile::Top | Tile::Bottom:
		{
			QPainterPath path;
			path.moveTo(2, TILE_SIZE - 6);
			path.quadTo(6, TILE_SIZE - 6, 6, TILE_SIZE - 2);
			path.moveTo(2, 6);
			path.quadTo(6, 6, 6, 2);
			path.moveTo(TILE_SIZE - 6, 2);
			path.lineTo(TILE_SIZE - 6, TILE_SIZE - 2);

			QPainterPath path1;
			path1.moveTo(2, TILE_SIZE - 7);
			path1.quadTo(7, TILE_SIZE - 7, 7, TILE_SIZE - 1);
			path1.lineTo(TILE_SIZE - 7, TILE_SIZE - 1);
			path1.lineTo(TILE_SIZE - 7, 1);
			path1.lineTo(7, 1);
			path1.quadTo(7, 7, 1, 7);
			path1.lineTo(1, TILE_SIZE - 7);

			QPainterPath path2;
			path2.moveTo(2, TILE_SIZE - 7);
			path2.quadTo(7, TILE_SIZE - 7, 7, TILE_SIZE - 2);
			path2.moveTo(2, 7);
			path2.quadTo(7, 7, 7, 2);
			path2.moveTo(TILE_SIZE - 7, 2);
			path2.lineTo(TILE_SIZE - 7, TILE_SIZE - 2);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}

		case Tile::Right | Tile::Top | Tile::Bottom:
		{
			QPainterPath path;
			path.moveTo(TILE_SIZE - 2, TILE_SIZE - 6);
			path.quadTo(TILE_SIZE - 6, TILE_SIZE - 6, TILE_SIZE - 6, TILE_SIZE - 2);
			path.moveTo(TILE_SIZE - 2, 6);
			path.quadTo(TILE_SIZE - 6, 6, TILE_SIZE - 6, 2);
			path.moveTo(6, 2);
			path.lineTo(6, TILE_SIZE - 2);

			QPainterPath path1;
			path1.moveTo(TILE_SIZE - 2, TILE_SIZE - 7);
			path1.quadTo(TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 1);
			path1.lineTo(7, TILE_SIZE - 1);
			path1.lineTo(7, 1);
			path1.lineTo(TILE_SIZE - 7, 1);
			path1.quadTo(TILE_SIZE - 7, 7, TILE_SIZE - 1, 7);
			path1.lineTo(TILE_SIZE - 1, TILE_SIZE - 7);

			QPainterPath path2;
			path2.moveTo(TILE_SIZE - 2, TILE_SIZE - 7);
			path2.quadTo(TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 7, TILE_SIZE - 2);
			path2.moveTo(TILE_SIZE - 2, 7);
			path2.quadTo(TILE_SIZE - 7, 7, TILE_SIZE - 7, 2);
			path2.moveTo(7, 2);
			path2.lineTo(7, TILE_SIZE - 2);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}

		case Tile::Left:
		{
			QPainterPath path;
			path.moveTo(2, 6);
			path.lineTo(TILE_SIZE - 6, 6);
			path.lineTo(TILE_SIZE - 6, TILE_SIZE - 6);
			path.lineTo(2, TILE_SIZE - 6);

			QPainterPath path1;
			path1.moveTo(1, 7);
			path1.lineTo(TILE_SIZE - 5, 7);
			path1.lineTo(TILE_SIZE - 5, TILE_SIZE - 7);
			path1.lineTo(1, TILE_SIZE - 7);
			path1.lineTo(1, 2);

			QPainterPath path2;
			path2.moveTo(2, 7);
			path2.lineTo(TILE_SIZE - 5, 7);
			path2.lineTo(TILE_SIZE - 5, TILE_SIZE - 7);
			path2.lineTo(2, TILE_SIZE - 7);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}

		case Tile::Top:
		{
			QPainterPath path;
			path.moveTo(6, 2);
			path.lineTo(6, 6);
			path.lineTo(TILE_SIZE - 6, 6);
			path.lineTo(TILE_SIZE - 6, 2);

			QPainterPath path1;
			path1.moveTo(7, 1);
			path1.lineTo(7, 5);
			path1.lineTo(TILE_SIZE - 7, 5);
			path1.lineTo(TILE_SIZE - 7, 1);
			path1.lineTo(2, 1);

			QPainterPath path2;
			path2.moveTo(7, 2);
			path2.lineTo(7, 5);
			path2.lineTo(TILE_SIZE - 7, 5);
			path2.lineTo(TILE_SIZE - 7, 2);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}

		case Tile::Right:
		{
			QPainterPath path;
			path.moveTo(TILE_SIZE - 2, 6);
			path.lineTo(TILE_SIZE - 6, 6);
			path.lineTo(TILE_SIZE - 6, TILE_SIZE - 6);
			path.lineTo(TILE_SIZE - 2, TILE_SIZE - 6);

			QPainterPath path1;
			path1.moveTo(TILE_SIZE - 1, 7);
			path1.lineTo(TILE_SIZE - 5, 7);
			path1.lineTo(TILE_SIZE - 5, TILE_SIZE - 7);
			path1.lineTo(TILE_SIZE - 1, TILE_SIZE - 7);
			path1.lineTo(TILE_SIZE - 1, 2);

			QPainterPath path2;
			path2.moveTo(TILE_SIZE - 2, 7);
			path2.lineTo(TILE_SIZE - 5, 7);
			path2.lineTo(TILE_SIZE - 5, TILE_SIZE - 7);
			path2.lineTo(TILE_SIZE - 2, TILE_SIZE - 7);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}

		case Tile::Bottom:
		{
			QPainterPath path;
			path.moveTo(6, TILE_SIZE - 2);
			path.lineTo(6, TILE_SIZE - 6);
			path.lineTo(TILE_SIZE - 6, TILE_SIZE - 6);
			path.lineTo(TILE_SIZE - 6, TILE_SIZE - 2);

			QPainterPath path1;
			path1.moveTo(7, TILE_SIZE - 1);
			path1.lineTo(7, TILE_SIZE - 5);
			path1.lineTo(TILE_SIZE - 7, TILE_SIZE - 5);
			path1.lineTo(TILE_SIZE - 7, TILE_SIZE - 1);
			path1.lineTo(2, TILE_SIZE - 1);

			QPainterPath path2;
			path2.moveTo(7, TILE_SIZE - 2);
			path2.lineTo(7, TILE_SIZE - 5);
			path2.lineTo(TILE_SIZE - 7, TILE_SIZE - 5);
			path2.lineTo(TILE_SIZE - 7, TILE_SIZE - 2);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::white);
			painter->drawPath(path);

			painter->setBrush(Qt::black);
			painter->setPen(Qt::NoPen);
			painter->drawPath(path1);

			painter->setBrush(Qt::NoBrush);
			painter->setPen(Qt::black);
			painter->drawPath(path2);

			break;
		}
	}

	painter->setOpacity(1);
	painter->setPen(Qt::white);
	painter->setBrush(Qt::NoBrush);
	painter->drawRect(adjusted);

	if (m_active)
	{
		const QRectF &rect = adjusted.adjusted(10, 10, -10, -10);

		painter->setBrush(m_color);
		painter->drawEllipse(rect);
	}
}
