#ifndef TILEHANDLER_H
#define TILEHANDLER_H

#include <QList>
#include <QObject>

class Tile;
class Player;

const int SIZE = 15;

class TileHandler : public QObject
{
	Q_OBJECT

	Q_PROPERTY(QList<Tile *> tiles READ tiles NOTIFY tilesChanged)

	public:
		TileHandler();

		QList<Tile *> neighbours(Tile *target) const;
		QList<Tile *> findCandidates(const Tile *active, int entrance, bool strict) const;
		QList<Tile *> tiles() const;

		Tile *tileAt(int x, int y);

		void updateCandidates(const Player *player, int entrance);

	private:
		QList<Tile *> m_tiles;

	signals:
		void tilesChanged();
};

#endif // TILEHANDLER_H
