#include "TileHandler.h"
#include "Tile.h"
#include "Player.h"

TileHandler::TileHandler()
{
	for (int y = 0; y < SIZE; y++)
	{
		for (int x = 0; x < SIZE; x++)
		{
			m_tiles << new Tile(x, y);
		}
	}
}

QList<Tile *> TileHandler::neighbours(Tile *target) const
{
	QList<Tile *> result;

	for (Tile *tile : m_tiles)
	{
		const int dx = qAbs(tile->x() - target->x());
		const int dy = qAbs(tile->y() - target->y());

		if (dx <= 1 && dy <= 1)
		{
			result << tile;
		}
	}

	return result;
}

QList<Tile *> TileHandler::findCandidates(const Tile *active, int entrance, bool strict) const
{
	QList<Tile *> result;

	for (Tile *tile : m_tiles)
	{
		if (tile->isCandidate(active, entrance, strict))
		{
			result << tile;
		}
	}

	return result;
}

QList<Tile *> TileHandler::tiles() const
{
	return m_tiles;
}

Tile *TileHandler::tileAt(int x, int y)
{
	for (Tile *tile : m_tiles)
	{
		if (tile->x() == x && tile->y() == y)
		{
			return tile;
		}
	}

	return nullptr;
}

void TileHandler::updateCandidates(const Player *player, int entrance)
{
	const Tile *playerTile = player->tile();

	for (Tile *tile : m_tiles)
	{
		tile->setCandidate(Tile::None);

		if (tile->isCandidate(playerTile, entrance, true))
		{
			tile->setCandidate(entrance);
		}
	}
}

